/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.thread;

import com.google.common.cache.CacheBuilder;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;

public class Cache {
    private static final Log logger = LogFactory.getInstance(Cache.class);
    private static final ThreadLocal<Cache> LOCAL = new ThreadLocal();
    private AtomicLong count = new AtomicLong();
    private Data data = new Data();
    private StackTraceElement[][] tracks;

    private Cache() {
    }

    public void share(Cache target, StackTraceElement[] caller, StackTraceElement[] callee) {
        Objects.requireNonNull(target, "target cache object should be non-null");
        target.tracks = new StackTraceElement[][]{caller, callee};
        target.data = this.data;
        Cache.recordCacheDataShareInfo(target.tracks, this.data.keys());
    }

    private static void recordCacheDataShareInfo(StackTraceElement[][] tracks, Collection<Object> keys) {
        if (tracks == null) {
            return;
        }
        List<StackTraceElement> chain = Arrays.asList(Cache.getFirstStackTraceElementOfBusinessCode(tracks[0]), Cache.getFirstStackTraceElementOfBusinessCode(tracks[0]));
        logger.debug((Object)"Share cache data between %s. keys: %s.", new Object[]{chain, keys});
    }

    private static StackTraceElement getFirstStackTraceElementOfBusinessCode(StackTraceElement[] stacks) {
        if (stacks == null) {
            return null;
        }
        List<String> ignores = Arrays.asList(Cache.class.getName(), ExecutionService.class.getName());
        for (StackTraceElement stack : stacks) {
            if (ignores.contains(stack.getClassName())) continue;
            return stack;
        }
        return null;
    }

    public Object data(Object key) {
        return this.data(key, null);
    }

    public Object data(Object key, Supplier<?> supplier) {
        return this.data.get(key, supplier);
    }

    public <T> T data(Class<T> type) {
        return type.cast(this.data((Object)type));
    }

    public <T> T data(Class<T> type, Supplier<T> supplier) {
        return type.cast(this.data((Object)type, (Supplier<?>)supplier));
    }

    public Cache data(Object key, Object value) {
        if (key != null) {
            this.data.put(key, value);
        }
        return this;
    }

    public Cache remove(Object key) {
        if (key != null) {
            this.data.remove(key);
        }
        return this;
    }

    private static Cache get(boolean init) {
        Cache local = LOCAL.get();
        if (local != null) {
            return local;
        }
        if (!init) {
            return null;
        }
        Cache cache = new Cache();
        LOCAL.set(cache);
        return cache;
    }

    public static Cache get() {
        return Cache.get(false);
    }

    public static Object get(Object key) {
        return Cache.eval(cache -> cache.data(key));
    }

    public static <T> T get(Object key, Supplier<T> supplier) {
        return (T)Cache.eval(cache -> cache.data(key, supplier), supplier);
    }

    public static <T> T get(Class<T> type) {
        return (T)Cache.eval(cache -> cache.data(type));
    }

    public static <T> T get(Class<T> type, Supplier<T> supplier) {
        return (T)Cache.eval(cache -> cache.data(type, supplier));
    }

    public static Cache set(Object key, Object value) {
        return Cache.eval(cache -> cache.data(key, value));
    }

    public static Cache delete(Object key) {
        return Cache.eval(cache -> cache.remove(key));
    }

    public static boolean contains(Object key) {
        return Boolean.TRUE.equals(Cache.eval(cache -> cache.data.containsKey(key)));
    }

    public static <T> T call(Callable<T> callable, Runnable ... callbacks) {
        Supplier<Object> supplier = () -> {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                throw LegoCheckedException.cast((Throwable)e, (long)-1L, (String[])new String[0]);
            }
        };
        return (T)Cache.run(supplier, callbacks);
    }

    public static <T> T eval(Function<Cache, T> function) {
        return Cache.eval(function, null);
    }

    public static <T> T eval(Function<Cache, T> function, Supplier<T> otherwise) {
        Cache cache = Cache.get();
        if (cache == null) {
            return otherwise != null ? (T)otherwise.get() : null;
        }
        return function.apply(cache);
    }

    public static <T> T run(Supplier<T> supplier, Runnable ... callbacks) {
        return Cache.run(supplier, false, callbacks);
    }

    public static <T> T run(Supplier<T> supplier, boolean isolated, Runnable ... callbacks) {
        return (T)Cache.run((Cache cache) -> supplier.get(), isolated, callbacks);
    }

    public static <T> T run(Function<Cache, T> function, Runnable ... callbacks) {
        return Cache.run(function, false, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T run(Function<Cache, T> function, boolean isolated, Runnable ... callbacks) {
        Cache cache = Cache.get(true);
        cache.count.incrementAndGet();
        Data base = cache.data;
        if (isolated) {
            cache.data = new Data(base);
        }
        try {
            T t = function.apply(cache);
            return t;
        }
        finally {
            if (isolated) {
                cache.data = base;
            }
            Cache.doPostProcess(cache, callbacks);
        }
    }

    private static void doPostProcess(Cache cache, Runnable[] callbacks) {
        long count = cache.count.decrementAndGet();
        if (count > 0L) {
            return;
        }
        LOCAL.remove();
        logger.debug((Object)"Cache data is already clean, keys: %s.", new Object[]{cache.data.keys()});
        if (callbacks == null) {
            return;
        }
        int n = callbacks.length;
        for (int i = 0; i < n; ++i) {
            Runnable callback = callbacks[i];
            try {
                callback.run();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("fail to execute callback " + i), (Throwable)e);
            }
        }
    }

    private static class Data {
        private com.google.common.cache.Cache<Object, Object> data = CacheBuilder.newBuilder().build();

        public Data() {
        }

        public Data(Data base) {
            if (base != null) {
                this.data.putAll((Map)base.data.asMap());
            }
        }

        public Collection<Object> keys() {
            return this.data.asMap().keySet();
        }

        public Object get(Object key) {
            return key != null ? this.data.getIfPresent(key) : null;
        }

        public void put(Object key, Object value) {
            if (key != null) {
                this.data.put(key, value);
            }
        }

        public Object get(Object key, Supplier<?> supplier) {
            if (key == null) {
                return null;
            }
            try {
                return this.data.get(key, () -> {
                    if (supplier == null) {
                        return null;
                    }
                    return supplier.get();
                });
            }
            catch (ExecutionException e) {
                logger.error((Object)("fail to get data for key " + key));
                return null;
            }
        }

        public boolean containsKey(Object key) {
            return key != null && this.data.asMap().containsKey(key);
        }

        public void remove(Object key) {
            if (key != null) {
                this.data.invalidate(key);
            }
        }
    }
}

