/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.thread;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public final class MemeryContext {
    private static final ThreadLocal<Map<Object, Object>> DATA = new ThreadLocal();

    private MemeryContext() {
    }

    public static <T> T get(Object key, Class<T> type) {
        Object value = MemeryContext.get(key);
        return type.isInstance(value) ? (T)type.cast(value) : null;
    }

    public static Object get(Object key) {
        Map<Object, Object> map = DATA.get();
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static void with(Object key, Object value, Runnable runnable) {
        MemeryContext.with(key, value, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T with(Object key, Object value, Supplier<T> supplier) {
        Map<Object, Object> map = DATA.get();
        boolean clean = false;
        if (map == null) {
            map = new HashMap<Object, Object>();
            DATA.set(map);
            clean = true;
        }
        Object old = map.put(key, value);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (old == null) {
                map.remove(key);
            } else {
                map.put(key, old);
            }
            if (clean) {
                DATA.remove();
            }
        }
    }
}

