/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.thread;

import com.huawei.lego.core.base.thread.CallableTask;
import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.base.thread.RootTask;
import com.huawei.lego.core.base.thread.RunnableTask;
import com.huawei.lego.core.base.thread.ThreadPool;
import com.huawei.lego.core.base.thread.ThreadPoolConfig;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;

public class ThreadPoolManager
extends CommonThread {
    private static final Log LOGGER = LogFactory.getInstance(ThreadPoolManager.class);
    private static final long SLEEP_TIME = 2000L;
    private static final int MAX_NUM = 5120;
    private static Map<Long, RootTask> sPoolTaskMap = Collections.synchronizedMap(new HashMap(5120));
    private static BlockingQueue<RootTask> sPollTaskWaitQueue = new LinkedBlockingQueue<RootTask>(5120);

    @Override
    public void execute() {
        ThreadPoolConfig config = ThreadPoolConfig.getThreadPoolConfig();
        int corePoolSize = config.getCorePoolSize();
        int maximumPoolSize = config.getMaximumPoolSize();
        int workQueueSize = config.getWorkQueueSize();
        long keepAliveTime = config.getKeepAliveTime();
        ThreadPool pool = new ThreadPool(corePoolSize, maximumPoolSize, keepAliveTime, workQueueSize);
        while (true) {
            try {
                while (true) {
                    CommonUtil.sleep((long)2000L);
                    int remainCapacity = pool.getRemainCapacity();
                    if (remainCapacity <= 0) continue;
                    this.scheduleTask(pool, remainCapacity);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("ThreadPoolManager sleep error." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                continue;
            }
            break;
        }
    }

    private void scheduleTask(ThreadPool pool, int remainCapacity) throws InterruptedException {
        for (int i = 0; i < remainCapacity; ++i) {
            RootTask task = sPollTaskWaitQueue.take();
            if (null == task) continue;
            pool.submitTask(task.getFutureTask());
            long taskTimeStamp = task.getTimeStamp();
            if (!task.isPeriodTask()) {
                ThreadPoolManager.deleteTask(taskTimeStamp);
                return;
            }
            this.addTask(task, taskTimeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(RootTask task, long taskTimeStamp) {
        Map<Long, RootTask> map = sPoolTaskMap;
        synchronized (map) {
            if (sPoolTaskMap.containsKey(taskTimeStamp) && !sPollTaskWaitQueue.contains(task)) {
                ThreadPoolManager.addTask(task, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FutureTask<?> addTask(RootTask task, boolean isSchedule) {
        Map<Long, RootTask> map = sPoolTaskMap;
        synchronized (map) {
            if (null == task) {
                return null;
            }
            if (sPoolTaskMap.size() > 5120) {
                LOGGER.error((Object)"sPoolTaskSet has reached max size, add task failed.", 1L);
                return null;
            }
            FutureTask<Object> futureTask = null;
            if (task instanceof RunnableTask) {
                futureTask = new FutureTask<Object>((RunnableTask)task, null);
            } else if (task instanceof CallableTask) {
                futureTask = new FutureTask((CallableTask)task);
            }
            if (null != futureTask) {
                task.setFutureTask(futureTask);
                if (!isSchedule) {
                    sPoolTaskMap.put(task.getTimeStamp(), task);
                }
                sPollTaskWaitQueue.add(task);
                return futureTask;
            }
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Add task fail, task is not RunnableTask or CallableTask:%s.", task), 1L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTask(long taskTimeStamp) {
        Map<Long, RootTask> map = sPoolTaskMap;
        synchronized (map) {
            sPoolTaskMap.remove(taskTimeStamp);
        }
    }
}

