/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.domain.context;

import com.huawei.lego.core.domain.context.BaseContext;
import com.huawei.lego.core.domain.context.ServiceTypeEnum;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import org.dom4j.Element;

public class ServiceContext
extends BaseContext {
    private static final long serialVersionUID = -8568277761600946843L;
    private static final Log LOGGER = LogFactory.getInstance(ServiceContext.class);
    private int type = 0;
    private Class srvClass = null;
    private String name = "";
    private Class enhancer = null;

    public ServiceContext(Element ele) {
        this.initContextField(this, ele);
        this.type = ServiceTypeEnum.convert(ele.attributeValue("type"));
        try {
            ClassLoader classLoader = AdapterUtils.getClassLoader(this.getClass());
            if (null != classLoader) {
                String enhancerStr;
                String srvClassStr = ele.attributeValue("srvClass");
                if (srvClassStr != null && !"".equals(srvClassStr)) {
                    this.srvClass = classLoader.loadClass(srvClassStr);
                }
                if ((enhancerStr = ele.attributeValue("enhancer")) != null && !"".equals(enhancerStr)) {
                    this.enhancer = classLoader.loadClass(enhancerStr);
                }
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    public Class getEnhancer() {
        return this.enhancer;
    }

    public void setEnhancer(Class enhancer) {
        this.enhancer = enhancer;
    }

    public String getServiceName() {
        return this.name;
    }

    public void setServiceName(String serviceName) {
        this.name = serviceName;
    }

    public int getServiceType() {
        return this.type;
    }

    public void setServiceType(int serviceType) {
        this.type = serviceType;
    }

    public Class getServiceClass() {
        return this.srvClass;
    }

    public void setServiceClass(Class serviceClass) {
        this.srvClass = serviceClass;
    }
}

