/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.nepoll;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.mediation.nepoll.PingPoll;
import com.huawei.lego.core.mediation.nepoll.PollPlugin;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Map;

public class NeUpdateSubscriber {
    private static final Log LOGGER = LogFactory.getInstance(NeUpdateSubscriber.class);

    public void onMessage(Map<Long, ManagedObject> msgObj) {
        if (msgObj == null) {
            LOGGER.error((Object)"Recv a null message object, message type: COMMAND_RES_UPDATE.");
            return;
        }
        try {
            Collection<ManagedObject> moList = msgObj.values();
            LOGGER.info((Object)"Recv a COMMAND_RES_UPDATE message, moIds: %s.", new Object[]{msgObj.keySet()});
            this.contructMessage(moList);
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    private void contructMessage(Collection<ManagedObject> moList) {
        for (ManagedObject mo : moList) {
            if (!(mo instanceof TopoObject)) continue;
            TopoObject topoMo = (TopoObject)mo;
            String moIP = topoMo.getIpAddress();
            if (moIP == null) {
                LOGGER.error((Object)"MoIP is null, can not add a poll task.");
                continue;
            }
            LOGGER.info((Object)"TopoObject contained in COMMAND_RES_UPDATE message which moId: %s, moIP: %s.", new Object[]{topoMo.getMoId(), moIP});
            String descr = topoMo.getDescription();
            if (descr != null && "manual".equals(descr)) {
                LOGGER.info((Object)"Recv a manual add device in NeUpdateSubscriber, no need to add a poll task, ip: %s.", new Object[]{moIP});
                continue;
            }
            this.updatePollTask(moIP, topoMo);
        }
    }

    private void updatePollTask(String moIP, TopoObject topoMo) {
        long moId = topoMo.getMoId();
        String moName = topoMo.getName();
        if (!topoMo.getSupportPing().booleanValue()) {
            LOGGER.error((Object)"No support ping,ip:%s,moId:%s,moName:%s.", new Object[]{moIP, moId, moName});
            return;
        }
        PollPlugin.getInstance().updatePingPoll(new PingPoll(moId, moIP, moName));
    }
}

