/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.syslog.hibernate;

import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.system.syslog.dao.IOptLogDao;
import com.huawei.lego.core.system.syslog.sdk.model.OptLogDetailMo;
import com.huawei.lego.core.system.syslog.sdk.model.OptLogMo;
import com.huawei.lego.core.system.syslog.service.SerialNumberContainer;
import java.sql.Blob;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;

public class OptLogDaoImpl
extends HibernateDaoSupportWrapper
implements IOptLogDao {
    @Override
    public void writeOptLog(OptLogMo oOptLog) {
        try {
            Long id = (Long)this.getHibernateTemplate().save((Object)oOptLog);
            oOptLog.setId(id);
        }
        catch (DataAccessException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        SerialNumberContainer.dealWithSerialNumber(oOptLog);
    }

    @Override
    public void updateOptLog(OptLogMo oOptLog) {
        try {
            this.getHibernateTemplate().update((Object)oOptLog);
        }
        catch (DataAccessException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void writeOptLog(OptLogMo oOptLog, byte[] logDetail) {
        Session session = null;
        try {
            session = this.getSessionFactory().getCurrentSession();
            if (null != session) {
                HibernateUtil.beginTransaction(session);
                Long optLogId = (Long)session.save((Object)oOptLog);
                oOptLog.setId(optLogId);
                OptLogDetailMo oLogDetail = new OptLogDetailMo();
                oLogDetail.setLogId(optLogId);
                Blob logBlob = Hibernate.getLobCreator((Session)session).createBlob(logDetail);
                oLogDetail.setOpLogDetail(logBlob);
                session.save((Object)oLogDetail);
                HibernateUtil.commit(session);
            }
        }
        catch (DataAccessException e) {
            HibernateUtil.rollbackSession(session);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        catch (Exception e) {
            if (session != null && session.getTransaction() != null) {
                session.getTransaction().rollback();
            }
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        SerialNumberContainer.dealWithSerialNumber(oOptLog);
    }
}

