/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.syslog.service;

import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.comm.SortUnit;
import com.huawei.lego.core.system.syslog.sdk.model.OptLogQCondition;
import com.huawei.lego.core.system.syslog.service.TranslateObject;
import java.util.List;
import java.util.Map;

public final class ConstructHsql {
    private static final int VALUE_1000 = 1000;

    private ConstructHsql() {
    }

    public static String constructOptLogQueryHsql(OptLogQCondition oOptLogQCondition, Map<Integer, String> param) {
        StringBuffer hsqlBuf = new StringBuffer(" as d ");
        boolean[] bEnter = new boolean[]{false};
        if (-1 != oOptLogQCondition.getiOptResult()) {
            hsqlBuf.append("WHERE d.opResult = ? ");
            bEnter[0] = true;
            param.put(param.size(), String.valueOf(oOptLogQCondition.getiOptResult()));
        }
        if (ConstructHsql.checkIsOld(oOptLogQCondition)) {
            ConstructHsql.processHSQL(bEnter, hsqlBuf);
            hsqlBuf.append("d.isOld != ? ");
            param.put(param.size(), oOptLogQCondition.getIsOld());
        }
        if (null != oOptLogQCondition.getDataBeginTime()) {
            ConstructHsql.processHSQL(bEnter, hsqlBuf);
            hsqlBuf.append("d.opTime >= ");
            hsqlBuf.append(oOptLogQCondition.getDataBeginTime().getTime());
        }
        if (null != oOptLogQCondition.getDataEndTime()) {
            ConstructHsql.processHSQL(bEnter, hsqlBuf);
            long temp = oOptLogQCondition.getDataEndTime().getTime() + 1000L;
            hsqlBuf.append("d.opTime < ");
            hsqlBuf.append(temp);
        }
        ConstructHsql.constructOptLogSecondQueryHsql(oOptLogQCondition, hsqlBuf, bEnter, param);
        ConstructHsql.constructOptLogThridQueryHsql(oOptLogQCondition, hsqlBuf, bEnter, param);
        return ConstructHsql.constructOptLogFourthQueryHsql(oOptLogQCondition, hsqlBuf, bEnter, param);
    }

    private static void processHSQL(boolean[] bEnter, StringBuffer hsqlBuf) {
        if (!bEnter[0]) {
            hsqlBuf.append("WHERE ");
            bEnter[0] = true;
        } else {
            hsqlBuf.append(" and ");
        }
    }

    private static boolean checkIsOld(OptLogQCondition oOptLogQCondition) {
        return null != oOptLogQCondition.getIsOld() && "true".equals(oOptLogQCondition.getIsOld());
    }

    private static void constructOptLogSecondQueryHsql(OptLogQCondition oOptLogQCondition, StringBuffer hsqlBuf, boolean[] bEnter, Map<Integer, String> param) {
        List lstStrOptFunctionType = oOptLogQCondition.getLstOptFunctionType();
        if (null != lstStrOptFunctionType && !lstStrOptFunctionType.isEmpty()) {
            if (!bEnter[0]) {
                hsqlBuf.append("WHERE ");
                bEnter[0] = true;
            } else {
                hsqlBuf.append(" and ");
            }
            hsqlBuf.append("d.optModuleName in ('");
            int iLength = oOptLogQCondition.getLstOptFunctionType().size();
            for (int i = 0; i < iLength; ++i) {
                hsqlBuf.append('?');
                param.put(param.size(), (String)lstStrOptFunctionType.get(i));
                if (iLength - 1 == i) {
                    hsqlBuf.append(')');
                    continue;
                }
                hsqlBuf.append(',');
            }
        }
    }

    private static void constructOptLogThridQueryHsql(OptLogQCondition oOptLogQCondition, StringBuffer hsqlBuf, boolean[] bEnter, Map<Integer, String> param) {
        List lstInterSecLevel = oOptLogQCondition.getLstSecLevel();
        if (null != lstInterSecLevel) {
            if (!bEnter[0]) {
                hsqlBuf.append("WHERE ");
                bEnter[0] = true;
            } else {
                hsqlBuf.append(" and ");
            }
            hsqlBuf.append("d.riskLevel in (");
            int iLength = lstInterSecLevel.size();
            for (int i = 0; i < iLength; ++i) {
                hsqlBuf.append('?');
                param.put(param.size(), String.valueOf(lstInterSecLevel.get(i)));
                if (iLength - 1 == i) {
                    hsqlBuf.append(')');
                    continue;
                }
                hsqlBuf.append(',');
            }
        }
    }

    private static String constructOptLogFourthQueryHsql(OptLogQCondition oOptLogQCondition, StringBuffer hsqlBuf, boolean[] bEnter, Map<Integer, String> param) {
        block6: {
            List lstStrUserName = oOptLogQCondition.getLstUserName();
            if (null == lstStrUserName) break block6;
            if (!bEnter[0]) {
                hsqlBuf.append(" WHERE ");
                bEnter[0] = true;
            } else {
                hsqlBuf.append(" and ");
            }
            if ("true".equals(oOptLogQCondition.getIsComplex())) {
                hsqlBuf.append("d.opUser like ? ");
                int iLength0 = oOptLogQCondition.getLstUserName().size();
                for (int i = 0; i < iLength0; ++i) {
                    String username = ConverterUtil.convertString(((String)lstStrUserName.get(i)).trim(), true);
                    param.put(param.size(), username);
                }
            } else {
                hsqlBuf.append("d.opUser = ? ");
                int iLength0 = oOptLogQCondition.getLstUserName().size();
                for (int i = 0; i < iLength0; ++i) {
                    String username = ((String)lstStrUserName.get(i)).trim();
                    param.put(param.size(), username);
                }
            }
        }
        return hsqlBuf.toString();
    }

    public static String constructSelHql(OptLogQCondition oOptLogQCondition, String hsql) {
        SortUnit su = oOptLogQCondition.getSortunit();
        StringBuffer hqlBuilder = new StringBuffer(hsql);
        if (null != su) {
            String field = TranslateObject.getDoFieldNameByBoFieldName(su.getFieldName());
            hqlBuilder.append(" order by ");
            hqlBuilder.append(field);
            hqlBuilder.append(" " + su.getSortType());
        } else {
            hqlBuilder.append(" order by d.opTime desc");
        }
        return hqlBuilder.toString();
    }
}

