/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.syslog.service;

import com.huawei.lego.core.system.syslog.sdk.model.OptLogMo;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class TranslateObject {
    private static final String SPLIT = "\n";
    private static final int TARGET_LOCAL_TRUE = 1;
    private static final int TARGET_LOCAL_FALSE = 0;
    private static final int DETAILS_SUBSTRING_INDEX_BEGINNING = 0;
    private static final int DETAILS_SUBSTRING_INDEX_END = 255;

    private TranslateObject() {
    }

    public static OptLogMo translateSysOptLogBo(SysOptLog oSysLog) {
        OptLogMo tmpOptLogMo = new OptLogMo();
        if (null != oSysLog.getDetail()) {
            int detailLength = oSysLog.getDetail().length();
            String detailSubString = 255 < detailLength ? oSysLog.getDetail().substring(0, 255) : oSysLog.getDetail();
            tmpOptLogMo.setOpDetail(detailSubString);
        }
        tmpOptLogMo.setOpIpAddress(oSysLog.getTerminalIp());
        tmpOptLogMo.setOpName(oSysLog.getOperation());
        tmpOptLogMo.setOpTarget(oSysLog.getTarget());
        tmpOptLogMo.setOpResult(oSysLog.getResult());
        tmpOptLogMo.setLogType(oSysLog.getLogType());
        if (null == oSysLog.getDate()) {
            tmpOptLogMo.setOpTime(System.currentTimeMillis());
        } else {
            tmpOptLogMo.setOpTime(oSysLog.getDate().getTime());
        }
        tmpOptLogMo.setOptModuleName(oSysLog.getModule());
        tmpOptLogMo.setOpUser(oSysLog.getOperator());
        tmpOptLogMo.setRiskLevel(oSysLog.getLevel());
        if (oSysLog.getTargetLocal().booleanValue()) {
            tmpOptLogMo.setTargetLocal(1);
        } else {
            tmpOptLogMo.setTargetLocal(0);
        }
        String[] param = oSysLog.getDetailPara();
        String detailPara = "";
        StringBuffer buffer = new StringBuffer("");
        if (null != param && param.length > 0) {
            int paraLenth = param.length;
            for (int i = 0; i < paraLenth; ++i) {
                buffer.append(param[i]);
                if (i == paraLenth - 1) continue;
                buffer.append(SPLIT);
            }
            detailPara = buffer.toString();
            tmpOptLogMo.setOpDetailPama(detailPara);
        }
        String[] targetParam = oSysLog.getTargetPara();
        StringBuffer targetBuffer = new StringBuffer("");
        TranslateObject.processTargeParam(targetBuffer, targetParam);
        TranslateObject.setTmpOptLogMoInfo(oSysLog, tmpOptLogMo, targetBuffer);
        return tmpOptLogMo;
    }

    private static void setTmpOptLogMoInfo(SysOptLog oSysLog, OptLogMo tmpOptLogMo, StringBuffer targetBuffer) {
        tmpOptLogMo.setOpTargetPama(targetBuffer.toString());
        tmpOptLogMo.setHasDetail(oSysLog.getHasDetail());
        tmpOptLogMo.setTokenUser(oSysLog.getTokenUser());
        tmpOptLogMo.setProjectId(oSysLog.getProjectId());
        tmpOptLogMo.setReported(false);
        tmpOptLogMo.setServiceType(oSysLog.getServiceType());
    }

    private static void processTargeParam(StringBuffer targetBuffer, String[] targetParam) {
        if (null != targetParam && targetParam.length > 0) {
            int paraLenth = targetParam.length;
            for (int i = 0; i < paraLenth; ++i) {
                targetBuffer.append(targetParam[i]);
                if (i == paraLenth - 1) continue;
                targetBuffer.append(SPLIT);
            }
        }
    }

    public static SysOptLog translateSysOptLogMo(OptLogMo oSysLogMo) {
        SysOptLog sysOptlog = new SysOptLog();
        sysOptlog.setId(oSysLogMo.getId().longValue());
        sysOptlog.setDetail(oSysLogMo.getOpDetail());
        sysOptlog.setTerminalIp(oSysLogMo.getOpIpAddress());
        sysOptlog.setOperation(oSysLogMo.getOpName());
        sysOptlog.setTarget(oSysLogMo.getOpTarget());
        sysOptlog.setResult(oSysLogMo.getOpResult());
        sysOptlog.setDate(new Date(oSysLogMo.getOpTime()));
        sysOptlog.setModule(oSysLogMo.getOptModuleName());
        sysOptlog.setOperator(oSysLogMo.getOpUser());
        sysOptlog.setLevel(oSysLogMo.getRiskLevel());
        sysOptlog.setGmt(oSysLogMo.getGmt());
        String param = oSysLogMo.getOpDetailPama();
        String[] detailParam = null;
        if (null != param && !param.equals("")) {
            detailParam = param.split(SPLIT);
        }
        sysOptlog.setDetailPara(detailParam);
        if (oSysLogMo.getTargetLocal() > 0) {
            sysOptlog.setTargetLocal(Boolean.TRUE);
        } else {
            sysOptlog.setTargetLocal(Boolean.FALSE);
        }
        String targetParam = oSysLogMo.getOpTargetPama();
        String[] targetParams = null;
        if (null != targetParam && !targetParam.equals("")) {
            targetParams = targetParam.split(SPLIT);
        }
        sysOptlog.setTargetPara(targetParams);
        sysOptlog.setHasDetail(oSysLogMo.getHasDetail());
        return sysOptlog;
    }

    public static List<SysOptLog> translateLstSysOptLogMo(List<OptLogMo> oSysLogMo) {
        ArrayList<SysOptLog> lstSysOptLog = new ArrayList<SysOptLog>();
        for (OptLogMo oOptLogMo : oSysLogMo) {
            lstSysOptLog.add(TranslateObject.translateSysOptLogMo(oOptLogMo));
        }
        return lstSysOptLog;
    }

    public static String longToStringData(long lMilliSecond) {
        Date dt = new Date(lMilliSecond);
        SimpleDateFormat dfToString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dfToString.format(dt);
    }

    public static Long stringToMilliSecondData(String sTime) throws ParseException {
        SimpleDateFormat dfToString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dt = dfToString.parse(sTime);
        return dt.getTime();
    }

    public static String getDoFieldNameByBoFieldName(String boFieldName) {
        if (boFieldName.equals("operation")) {
            return "opName";
        }
        if (boFieldName.equals("level")) {
            return "riskLevel";
        }
        if (boFieldName.equals("operator")) {
            return "opUser";
        }
        if (boFieldName.equals("date")) {
            return "opTime";
        }
        return TranslateObject.getFieldName(boFieldName);
    }

    private static String getFieldName(String boFieldName) {
        if (boFieldName.equals("module")) {
            return "optModuleName";
        }
        if (boFieldName.equals("terminalIp")) {
            return "opIpAddress";
        }
        if (boFieldName.equals("target")) {
            return "opTarget";
        }
        if (boFieldName.equals("result")) {
            return "opResult";
        }
        if (boFieldName.equals("detail")) {
            return "opDetail";
        }
        return "id";
    }
}

