/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.sysmonitor.service.treshold;

import com.huawei.lego.cbb.user.service.common.SystemInitializeUser;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTreshold;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTresholdType;
import com.huawei.lego.core.system.sysmonitor.service.treshold.ISysmTresholdService;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SystemInitializeHold
implements SystemStatusChangedListener {
    private static final Properties PROPS = new Properties();
    private static final String DEFAULT_PROPERTIES = "conf.properties";
    private static final Log LOG = LogFactory.getInstance(SystemInitializeHold.class);
    private static boolean propertyInit = false;
    private ISysmTresholdService sysTresholdService;
    private ICommonDao dao;

    public void afterPropertiesSet() {
        this.initSysHold();
    }

    private void initSysHold() {
        List<SysmTreshold> list = this.sysTresholdService.getSysmTreshold();
        if (null == list || list.isEmpty()) {
            this.initProperty();
            this.initFaultHold();
        }
    }

    private void initFaultHold() {
        SysmTreshold cpuTreshold = new SysmTreshold();
        cpuTreshold.setPercent((long)this.getInt("cpu"));
        long level = FaultEnum.AlarmSeverity.MAJOR.getValue();
        cpuTreshold.setAlarmLevel(level);
        cpuTreshold.setId(Long.valueOf(SysmTresholdType.CPU.getValue()));
        SysmTreshold memTreshold = new SysmTreshold();
        memTreshold.setPercent((long)this.getInt("mem"));
        memTreshold.setAlarmLevel(level);
        memTreshold.setId(Long.valueOf(SysmTresholdType.MEM.getValue()));
        SysmTreshold diskTreshold = new SysmTreshold();
        diskTreshold.setPercent((long)this.getInt("disk"));
        diskTreshold.setAlarmLevel(level);
        diskTreshold.setId(Long.valueOf(SysmTresholdType.DISK.getValue()));
        SysmTreshold dbTreshold = new SysmTreshold();
        dbTreshold.setPercent((long)this.getInt("db"));
        dbTreshold.setAlarmLevel(level);
        dbTreshold.setId(Long.valueOf(SysmTresholdType.DB.getValue()));
        this.dao.save(cpuTreshold);
        this.dao.save(memTreshold);
        this.dao.save(diskTreshold);
        this.dao.save(dbTreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProperty() {
        if (propertyInit) {
            return;
        }
        InputStream stream = null;
        try {
            URL url;
            ClassLoader cl = AdapterUtils.getClassLoader(this.getClass());
            String jarfileName = AdapterUtils.getClassJarPath(SystemInitializeUser.class);
            if (null != cl && null != jarfileName && null != (url = AdapterUtils.getUrlResourceFromJar((ClassLoader)cl, (String)jarfileName, (String)DEFAULT_PROPERTIES))) {
                stream = url.openStream();
                PROPS.load(stream);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"read default.properties fail.", (Throwable)e, 0L);
        }
        catch (Exception e) {
            LOG.error((Object)("ERROR:" + ExceptionUtil.getErrorMessage((Throwable)e)), 0L);
        }
        finally {
            try {
                if (null != stream) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", (Throwable)e, 0L);
            }
        }
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)PROPS);
        System.setProperties(sysProps);
        propertyInit = true;
    }

    public String getProperty(String key, String defaultValue) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    public int getInt(String key) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            return 0;
        }
        return NumberUtil.convertToInteger((Object)value);
    }

    public void setSysTresholdService(ISysmTresholdService sysTresholdService) {
        this.sysTresholdService = sysTresholdService;
    }

    public void setDao(ICommonDao dao) {
        this.dao = dao;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.afterPropertiesSet();
        }
    }
}

