/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.template.dao;

import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.template.dao.ITemplateDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class TemplateDaoImpl
extends HibernateDaoSupportWrapper
implements ITemplateDao {
    private static final Log LOGGER = LogFactory.getInstance(TemplateDaoImpl.class);

    @Override
    public boolean addTemplate(Protocol template, String className) {
        try {
            this.getHibernateTemplate().save(className, (Object)template);
            return true;
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)("addTemplate error, templateName: " + template.getTemplateName()), (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public Long addTemplateReturnKey(Protocol template, String className) {
        try {
            return (Long)this.getHibernateTemplate().save(className, (Object)template);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)("addTemplateReturnKey error, templateName: " + template.getTemplateName()), (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public boolean updateTemplate(Protocol template, String className) {
        try {
            Protocol oldTemplate = (Protocol)this.getHibernateTemplate().get(className, (Serializable)template.getId());
            if (null == oldTemplate) {
                String[] param = new String[]{className};
                throw new LegoCheckedException(204L, param);
            }
            this.getHibernateTemplate().update(className, (Object)template);
            return true;
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)new StringBuilder().append("updateTemplate error, templateId: ").append(template.getId()).append(", templateName: ").append(template.getTemplateName()), (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public Protocol getTemplate(Serializable id, String className) {
        try {
            Protocol template = (Protocol)this.getHibernateTemplate().get(className, id);
            if (null == template) {
                String[] param = new String[]{className};
                throw new LegoCheckedException(204L, param);
            }
            return template;
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)("getTemplate error, id: " + id), (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public List<Protocol> getAllTemplate() {
        StringBuffer queryString = new StringBuffer();
        queryString.append("from " + Protocol.class.getName());
        ArrayList<Protocol> templateList = new ArrayList<Protocol>();
        List list = this.getHibernateTemplate().find(queryString.toString(), new Object[0]);
        for (Object obj : list) {
            if (!(obj instanceof Protocol)) continue;
            templateList.add((Protocol)obj);
        }
        return templateList;
    }
}

