/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.dao.impl;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IAlarmClearService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AlarmClearProcess {
    private static final Log LOGGER = LogFactory.getInstance(AlarmClearProcess.class);
    private static List<IAlarmClearService> alarmClearServiceList = new ArrayList<IAlarmClearService>();

    public static boolean clearAlarm(LegoAlarm legoAlarm, String userName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("clearAlarm,user:");
        buffer.append(userName);
        buffer.append(",alarmId:");
        buffer.append(legoAlarm.getAlarmId());
        buffer.append(",alarmName:");
        buffer.append(legoAlarm.getAlarmName());
        buffer.append(",moName:");
        buffer.append(legoAlarm.getMoName());
        buffer.append(",result:");
        if (null == alarmClearServiceList || alarmClearServiceList.isEmpty()) {
            buffer.append("false,alarmClearServiceList is empty.");
            LOGGER.debug((Object)buffer.toString(), 1L);
            return true;
        }
        try {
            for (IAlarmClearService service : alarmClearServiceList) {
                if (!service.isMyMo(legoAlarm.getMoId())) continue;
                boolean clearResult = service.clearAlarm(legoAlarm, userName);
                buffer.append(clearResult);
                buffer.append(",product send cmd.");
                LOGGER.debug((Object)buffer.toString(), 1L);
                return clearResult;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(buffer.toString() + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        LOGGER.debug((Object)"false,happen exception or not found service for mo(all service.isMyMo is false).", 1L);
        return true;
    }

    public void onBind(IAlarmClearService service, Map<String, String> properties) {
        if (null != service) {
            alarmClearServiceList.add(service);
            LOGGER.info((Object)String.format(Locale.ENGLISH, "OnBind:%s.", service), 1L);
        } else {
            LOGGER.info((Object)"onBind,service is null.", 1L);
        }
    }

    public void onUnbind(IAlarmClearService service, Map<String, String> properties) {
        if (null != service) {
            alarmClearServiceList.remove(service);
            LOGGER.info((Object)String.format(Locale.ENGLISH, "OnUnbind:%s.", service), 1L);
        } else {
            LOGGER.info((Object)"onUnbind,service is null.", 1L);
        }
    }

    public static List<IAlarmClearService> getAlarmClearServiceList() {
        return alarmClearServiceList;
    }

    public static void setAlarmClearServiceList(List<IAlarmClearService> alarmClearServiceList) {
        AlarmClearProcess.alarmClearServiceList = alarmClearServiceList;
    }
}

