/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.launcher.impl;

import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.define.FaultDefineCacher;
import com.huawei.lego.nem.fault.define.FaultFileParser;
import com.huawei.lego.nem.fault.launcher.IFaultLauncher;
import com.huawei.lego.nem.fault.launcher.impl.AlarmSyncLauncher;
import com.huawei.lego.nem.fault.sdk.model.FaultConf;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.sdk.service.IAlarmSynchronize;
import com.huawei.lego.nem.fault.sdk.service.IFaultDefineService;
import com.huawei.lego.nem.fault.util.MoType;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FaultDefineLauncher
implements IFaultLauncher {
    private static final Log LOGGER = LogFactory.getInstance(FaultDefineLauncher.class);
    private IFaultDefineService faultDefineSrv = null;
    private FaultDefine offLineDefine = null;
    private Map<String, List<FaultConf>> faultMap = new HashMap<String, List<FaultConf>>();
    private Map<String, MoType> moTypeMap = new HashMap<String, MoType>();

    public FaultDefine getOffLineDefine() {
        return this.offLineDefine;
    }

    public void setOffLineDefine(FaultDefine offLineDefine) {
        this.offLineDefine = offLineDefine;
    }

    @Override
    public void start() {
        LOGGER.info((Object)"[FaultLauncher] begin to start FaultDefineLauncher.", 1L);
        this.faultDefineSrv.deleteAllFaultDefine();
        this.refreshFaultDefine();
        ArrayList offlineDefines = new ArrayList();
        this.faultDefineSrv.registerFaultDefine(offlineDefines);
        this.faultMap.clear();
    }

    @Override
    public void stop() {
        FaultDefineCacher.clearCacheFaultDefine();
    }

    private void refreshFaultDefine() {
        ArrayList<FaultConf> faultConfiList = new ArrayList<FaultConf>();
        List urlList = AdapterUtils.getAllClassPathEntries((String)"fault/*-fault-define.xml");
        for (URL url : urlList) {
            faultConfiList.addAll(this.parseFaultFile(url));
        }
        this.processFaultFile(faultConfiList);
    }

    private List<FaultConf> parseFaultFile(URL url) {
        LOGGER.info((Object)"Begin parse FaultFile.", 1L);
        List<FaultConf> faultConfiList = FaultFileParser.parseFaultFile(url);
        this.faultMap.put(url.getPath(), faultConfiList);
        return faultConfiList;
    }

    private void processFaultFile(List<FaultConf> faultConfiList) {
        HashMap<String, FaultDefine> faultDefinedMap = new HashMap<String, FaultDefine>();
        ArrayList faultDefineList = new ArrayList();
        for (FaultConf faultConf : faultConfiList) {
            if (faultConf.isBaseCfg()) continue;
            faultDefinedMap.clear();
            for (FaultDefine define : faultConf.getDefineList()) {
                faultDefinedMap.put(define.getFaultId(), define);
            }
            this.setBaseTrap(faultConf, faultConf, faultDefinedMap);
            String productName = faultConf.getBundleName();
            String trapoid = faultConf.getTrapoid();
            String trapclass = faultConf.getTrapclass();
            String synchronizeclass = faultConf.getSynchronizeclass();
            this.saveMoType(faultConf);
            try {
                if (!"".equals(synchronizeclass)) {
                    IAlarmSynchronize service = (IAlarmSynchronize)Thread.currentThread().getContextClassLoader().loadClass(synchronizeclass).newInstance();
                    AlarmSyncLauncher.addAlarmSynchronizer(service, productName, trapoid);
                }
                faultDefineList.addAll(faultConf.getDefineList());
            }
            catch (Exception e) {
                LOGGER.error((Object)(new StringBuilder().append("Exception occured in parseFaultFile, productName: ").append(productName).append(", trapoid: ").append(trapoid).append(", trapclass: ").append(trapclass) + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            FaultDefineCacher.cacheFaultDefine(faultConf);
        }
        this.faultDefineSrv.registerFaultDefine(faultDefineList);
    }

    private void setBaseTrap(FaultConf parentFaultConf, FaultConf childFaultConf, Map<String, FaultDefine> faultDefinedMap) {
        String[] fileNames;
        for (String fileName : fileNames = childFaultConf.getIncludeAlarmFile()) {
            if (null == fileName || "".equals(fileName) || parentFaultConf.getFileNames().contains(fileName)) continue;
            parentFaultConf.getFileNames().add(fileName);
            List<FaultConf> baseConfiList = this.faultMap.get(fileName);
            if (null == baseConfiList || baseConfiList.isEmpty()) continue;
            for (FaultConf baseFaultConf : baseConfiList) {
                List faultDefineList = baseFaultConf.getDefineList();
                this.addFaultDefine(faultDefinedMap, parentFaultConf, faultDefineList);
                this.setBaseTrap(parentFaultConf, baseFaultConf, faultDefinedMap);
            }
        }
    }

    private void saveMoType(FaultConf faultConf) {
        try {
            if (!faultConf.isIncludeOffLineAlarm()) {
                return;
            }
            List defineList = faultConf.getDefineList();
            for (FaultDefine faultDefine : defineList) {
                String mainType = faultDefine.getMoMainType();
                String subType = faultDefine.getMoSubType();
                this.moTypeMap.put(mainType + "_" + subType, new MoType(mainType, subType, faultDefine.getProductName(), faultDefine.getTrapoid()));
                if (!faultDefine.getFaultId().equals("0x000803220005")) continue;
                this.offLineDefine = faultDefine;
            }
            if (defineList.isEmpty()) {
                this.moTypeMap.put(faultConf.getMoMainType() + "_" + faultConf.getMoSubType(), new MoType(faultConf.getMoMainType(), faultConf.getMoSubType(), faultConf.getBundleName(), faultConf.getTrapoid()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    private void addFaultDefine(Map<String, FaultDefine> faultDefinedMap, FaultConf parentFaultConf, List<FaultDefine> faultDefineList) {
        for (FaultDefine faultDefine : faultDefineList) {
            FaultDefine faultDefineClone = new FaultDefine();
            faultDefineClone.setProductName(parentFaultConf.getBundleName());
            faultDefineClone.setAdvice(faultDefine.getAdvice());
            faultDefineClone.setFaultDesc(faultDefine.getFaultDesc());
            faultDefineClone.setFaultId(faultDefine.getFaultId());
            faultDefineClone.setFaultLevel(faultDefine.getFaultLevel());
            faultDefineClone.setFaultName(faultDefine.getFaultName());
            faultDefineClone.setFaultType(faultDefine.getFaultType());
            faultDefineClone.setGenericType(faultDefine.getGenericType());
            faultDefineClone.setKeyIndexs(faultDefine.getKeyIndexs());
            faultDefineClone.setLocation(faultDefine.getLocation());
            faultDefineClone.setMoMainType(parentFaultConf.getMoMainType());
            faultDefineClone.setMoSubType(parentFaultConf.getMoSubType());
            faultDefineClone.setProductName(parentFaultConf.getBundleName());
            faultDefineClone.setRelateId(faultDefine.getRelateId());
            faultDefineClone.setSpecificType(faultDefine.getSpecificType());
            faultDefineClone.setSysEffect(faultDefine.getSysEffect());
            faultDefineClone.setTrapoid(parentFaultConf.getTrapoid());
            faultDefineClone.setTrapType(faultDefine.getTrapType());
            faultDefineClone.setTrapsExtendProperty(faultDefine.getTrapsExtendProperty());
            faultDefineClone.setTrapExtendProperty(faultDefine.getTrapExtendProperty());
            if (faultDefinedMap.containsKey(faultDefineClone.getFaultId())) continue;
            parentFaultConf.addFaultDefine(faultDefineClone);
            faultDefinedMap.put(faultDefineClone.getFaultId(), faultDefineClone);
        }
    }

    public void setFaultDefineSrv(IFaultDefineService faultDefineSrv) {
        this.faultDefineSrv = faultDefineSrv;
    }
}

