/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.product;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import com.huawei.lego.nem.fault.sdk.service.IProductDevTypeService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DevTypeServiceContainer {
    private static final Log logger = LogFactory.getInstance(DevTypeServiceContainer.class);
    private static List<IProductDevTypeService> devTypeSrvList = new ArrayList<IProductDevTypeService>();

    private static void setDeviceTypeServiceListVar(List<IProductDevTypeService> devTypeSrvListParam) {
        devTypeSrvList = devTypeSrvListParam;
    }

    public static RootDataElement getDeviceTypeTree(RootDataElement treeRoot, Long userId, Locale locale) {
        if (null == devTypeSrvList || devTypeSrvList.isEmpty()) {
            return treeRoot;
        }
        try {
            RootDataElement tempTree = treeRoot;
            for (IProductDevTypeService service : devTypeSrvList) {
                tempTree = service.getDeviceTypeTree(tempTree, userId, locale);
            }
            return tempTree;
        }
        catch (Exception t) {
            logger.error((Object)("getDeviceTypeTree exception." + ExceptionUtil.getErrorMessage((Throwable)t)), 1L);
            return treeRoot;
        }
    }

    public void onBind(IProductDevTypeService service, Map<String, String> properties) {
        if (null != service) {
            devTypeSrvList.add(service);
            logger.info((Object)String.format(Locale.ENGLISH, "OnBind:%s.", service), 1L);
        } else {
            logger.info((Object)"onBind,service is null.", 1L);
        }
    }

    public void onUnbind(IProductDevTypeService service, Map<String, String> properties) {
        if (null != service) {
            devTypeSrvList.remove(service);
            logger.info((Object)String.format(Locale.ENGLISH, "OnUnbind:%s.", service), 1L);
        } else {
            logger.info((Object)"onUnbind,service is null.", 1L);
        }
    }

    public static List<IProductDevTypeService> getDevTypeSrvList() {
        return devTypeSrvList;
    }

    public void setDevTypeSrvList(List<IProductDevTypeService> devTypeSrvList) {
        DevTypeServiceContainer.setDeviceTypeServiceListVar(devTypeSrvList);
    }
}

