/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.product;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.nem.fault.sdk.service.IProductLinkResService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LinkResServiceContainer {
    private static final Log logger = LogFactory.getInstance(LinkResServiceContainer.class);
    private static List<IProductLinkResService> linkResSrvList = new ArrayList<IProductLinkResService>();

    public static boolean isShowLinkRes() {
        String customProductName;
        List<String> ignores = Arrays.asList("OceanStor BCManager eReplication", "BCManager eReplication", "BCManager", "UltraVR");
        if (ignores.contains(customProductName = LegoProperties.getProperty((String)"customProductname", (String)""))) {
            return false;
        }
        if (null == linkResSrvList || linkResSrvList.isEmpty()) {
            return true;
        }
        boolean isShowResult = true;
        try {
            for (IProductLinkResService service : linkResSrvList) {
                isShowResult = service.showLinkRes();
            }
            return isShowResult;
        }
        catch (Exception t) {
            logger.error((Object)("LinkResServiceContainer exception." + ExceptionUtil.getErrorMessage((Throwable)t)), 1L);
            return isShowResult;
        }
    }

    public void onBind(IProductLinkResService service, Map<String, String> properties) {
        if (null != service) {
            linkResSrvList.add(service);
            logger.info((Object)String.format(Locale.ENGLISH, "OnBind:%s.", service), 1L);
        } else {
            logger.info((Object)"onBind,service is null.", 1L);
        }
    }

    public void onUnbind(IProductLinkResService service, Map<String, String> properties) {
        if (null != service) {
            linkResSrvList.remove(service);
            logger.info((Object)String.format(Locale.ENGLISH, "OnUnbind:%s.", service), 1L);
        } else {
            logger.info((Object)"onUnbind,service is null.", 1L);
        }
    }

    public static List<IProductLinkResService> getLinkResSrvList() {
        return linkResSrvList;
    }

    public static void setLinkResSrvList(List<IProductLinkResService> linkResSrvList) {
        LinkResServiceContainer.linkResSrvList = linkResSrvList;
    }
}

