/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.sync;

import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.lego.nem.fault.dao.IAlarmDAO;
import com.huawei.lego.nem.fault.launcher.impl.AlarmSyncLauncher;
import com.huawei.lego.nem.fault.sdk.model.AlarmSyncTask;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.service.IAlarmSynchronize;
import com.huawei.lego.nem.fault.sync.AlarmSynchronizerBean;
import com.huawei.lego.nem.fault.sync.SynchronizeTask;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AlarmSynchronizer {
    private static final String KEY_IS_TRAP = "isTrap";
    private static final Log LOGGER = LogFactory.getInstance(AlarmSynchronizer.class);
    private ExecutorService threadPool = Executors.newFixedThreadPool(1);
    private IAlarmDAO alarmDAO = null;
    private IDiscoveryService discoveryService;
    private IResourceService resService;

    public synchronized void createSyncTask(long moId, String moName, String moIP, FaultEnum.AlarmSyncType syncType) {
        AlarmSyncTask tempTask;
        LOGGER.info((Object)new StringBuilder().append("create a Alarm Synchronize task, moId: ").append(moId).append(", moIP: ").append(moIP).append(", moName").append(moName).append(", syncType: ").append(syncType), 1L);
        try {
            AlarmSynchronizerBean bean = this.checkException(moId);
            LOGGER.info((Object)String.format(Locale.ENGLISH, "AlarmSynchronizerBean was found.productName:%s,%s,%s.", bean.getProductName(), bean.getTrapoid(), bean.getService().toString()), 1L);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"product throw LegoCheckedException.", (Throwable)e, 1L);
            throw e;
        }
        catch (LegoUncheckedException e) {
            LOGGER.error((Object)"product throw LegoUncheckedException.", (Throwable)e, 1L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"product unknown exception.", (long)1563L, null, (Log)LOGGER);
        }
        AlarmSyncTask task = new AlarmSyncTask(moId, moName, moIP, System.currentTimeMillis());
        task.setTaskType(syncType.getValue());
        if (syncType == FaultEnum.AlarmSyncType.MANU_SYNC && null != (tempTask = this.alarmDAO.getAlarmSyncTask(moId, FaultEnum.AlarmSyncType.MANU_SYNC))) {
            throw new LegoCheckedException(1566L);
        }
        long taskId = this.alarmDAO.addAlarmSyncTask(task);
        this.launchSyncTask(this.alarmDAO.getAlarmSyncTask(taskId));
    }

    public void launchSyncTask(AlarmSyncTask task) {
        if (null == task) {
            LOGGER.error((Object)"launchSyncTask failed, input param AlarmSyncTask is null.", 1L);
            throw new LegoCheckedException(1568L);
        }
        String isTrapStr = LegoProperties.getProperty((String)KEY_IS_TRAP, (String)Boolean.FALSE.toString());
        if (isTrapStr.equals(Boolean.FALSE.toString())) {
            LOGGER.info((Object)"The launchSyncTask is forbidden", 1L);
            return;
        }
        if (task.getTaskStatus() == 1) {
            LOGGER.info((Object)new StringBuilder().append("alarm synchronize task is executing, wait a moment, moId: ").append(task.getMoId()).append(", moIP: ").append(task.getMoIP()).append(", moName: " + task.getMoName()), 1L);
            throw new LegoCheckedException(1567L);
        }
        AlarmSynchronizerBean syncBean = this.checkException(task.getMoId());
        SynchronizeTask syncTask = new SynchronizeTask(syncBean, task.getMoId());
        syncTask.setResService(this.resService);
        syncTask.setDiscoveryService(this.discoveryService);
        task.setTimeStamp(System.currentTimeMillis());
        task.setEndTime(0L);
        task.setTaskStatus(1);
        task.setErrorCode(-1L);
        task.setResultCount(0);
        this.alarmDAO.updateAlarmSyncTask(task);
        syncTask.setTask(task);
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Submit Alarm SynchronizeTask to ThreadPool: %s.", syncTask), 1L);
        Future<Integer> future = this.threadPool.submit(syncTask);
        if (null == future) {
            LOGGER.error((Object)"threadPool.submit return null", 1L);
        }
    }

    public void launchSyncTask(long moId, String moIP, String moName) {
        LOGGER.info((Object)new StringBuilder().append("launch a Alarm Synchronize operation, moId: ").append(moId).append(", moIP: ").append(moIP).append(", moName").append(moName), 1L);
        AlarmSyncTask task = this.alarmDAO.getAlarmSyncTask(moId, FaultEnum.AlarmSyncType.MANU_SYNC);
        if (null == task) {
            this.createSyncTask(moId, moName, moIP, FaultEnum.AlarmSyncType.MANU_SYNC);
        } else {
            this.launchSyncTask(task);
        }
    }

    private AlarmSynchronizerBean checkException(long moId) {
        AlarmSynchronizerBean syncBean = AlarmSyncLauncher.getSynchronizer(moId);
        if (null == syncBean) {
            LOGGER.error((Object)("no AlarmSynchronizerBean was found, moId: " + moId), 1L);
            throw new LegoCheckedException(1550L);
        }
        IAlarmSynchronize synchronizer = syncBean.getService();
        if (null == synchronizer) {
            LOGGER.error((Object)("no IAlarmSynchronize impl was found, moId: " + moId), 1L);
            throw new LegoCheckedException(1550L);
        }
        if (!synchronizer.isSupportSynchronize(moId)) {
            LOGGER.error((Object)("device does not support alarm synchrnonize, moId: " + moId), 1L);
            throw new LegoCheckedException(1549L);
        }
        return syncBean;
    }

    public void updateTask(AlarmSyncTask syncTask, long errorCode) {
        syncTask.setTaskStatus(2);
        syncTask.setEndTime(System.currentTimeMillis());
        syncTask.setErrorCode(errorCode);
        this.alarmDAO.updateAlarmSyncTask(syncTask);
    }

    public void setAlarmDAO(IAlarmDAO alarmDAO) {
        this.alarmDAO = alarmDAO;
    }

    public void setResService(IResourceService resService) {
        this.resService = resService;
    }

    public void setDiscoveryService(IDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }
}

