/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.nem.fault.define.FaultDefineUtil;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.AlarmDetail;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.model.LegoEvent;
import com.huawei.lego.nem.fault.sdk.model.RestoreInfo;
import com.huawei.lego.nem.fault.sdk.util.FaultSdkUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public final class FaultUtil {
    private static final int VALUE_2 = 2;
    private static final String TRAP_FILE = "trap.properties";
    private static final int DEFAULT_TRAPPORT = 162;
    private static final Log LOGGER = LogFactory.getInstance(FaultUtil.class);
    private static SimpleDateFormat sFormat = null;

    private FaultUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getTrapPort() {
        InputStream is = null;
        int port = LegoProperties.getTrapPort();
        if (0 == port) {
            Properties props = new Properties();
            ClassLoader cl = FaultUtil.class.getClassLoader();
            if (null != cl) {
                is = cl.getResourceAsStream(TRAP_FILE);
                props.load(is);
                port = NumberUtil.convertToInteger((Object)props.getProperty("trapport"));
            }
        }
        int n = port;
        try {
            if (null != is) {
                is.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Close TRAP_FILE failed. errMsg:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return n;
        catch (Exception e) {
            try {
                LOGGER.error((Object)("parse TrapPort failed, use default trap port 162." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            catch (Throwable throwable) {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    LOGGER.error((Object)"Close TRAP_FILE failed. errMsg:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
                }
                throw throwable;
            }
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException e3) {
                LOGGER.error((Object)"Close TRAP_FILE failed. errMsg:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e3)});
            }
        }
        return 162;
    }

    public static String getEntityLego(long moId, String alarmId, String keyIndexs, String[] params) {
        StringBuffer buf = new StringBuffer();
        buf.append(moId);
        buf.append(alarmId);
        if (null == params) {
            return buf.toString();
        }
        try {
            if (null != keyIndexs && keyIndexs.equals("AllKeyIndexs")) {
                for (int i = 0; i < params.length; ++i) {
                    buf.append(params[i]);
                }
            } else if (null != keyIndexs && !keyIndexs.equals("")) {
                String[] keys = keyIndexs.split(",");
                for (int i = 0; i < keys.length; ++i) {
                    buf.append(params[NumberUtil.convertToInteger((Object)keys[i])]);
                }
            }
        }
        catch (Exception e) {
            FaultUtil.writeErrorLog(alarmId, params, e);
        }
        String entity = buf.toString();
        entity = FaultUtil.replaceEntity(entity);
        if (entity.length() > 255) {
            LOGGER.error((Object)("The length of entity is too long,length:" + entity.length() + ",entity:" + entity), 1L);
        }
        return entity;
    }

    public static String getEntity(long moId, String alarmId, String keyIndexs, String[] params) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetEntity:alarmId is %s.", alarmId));
        return FaultUtil.getEntityLego(moId, alarmId, keyIndexs, params);
    }

    public static String replaceEntity(String entity) {
        LOGGER.debug((Object)"replaceEntity");
        return entity.replaceAll("\\(", "a").replaceAll("\\)", "b").replaceAll("<", "c").replaceAll(">", "d").replaceAll("\"", "e").replaceAll("'", "f").replaceAll(" ", "").replaceAll("%", "g").replaceAll("`", "h").replaceAll("\\+", "i").replaceAll("&", "j").replaceAll("\r", "k").replaceAll("\n", "l").replaceAll("#", "m").replaceAll(",", "n").replaceAll(";", "o");
    }

    private static void writeErrorLog(String alarmId, String[] params, Exception exception) {
        try {
            List<String> strList = Arrays.asList(params);
            StringBuffer buffer = new StringBuffer();
            buffer.append("exception while getEntity, eventId: ");
            buffer.append(alarmId);
            buffer.append(", eventParam: ");
            buffer.append(strList);
            LOGGER.error((Object)(buffer.toString() + ExceptionUtil.getErrorMessage((Throwable)exception)), 1L);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("writeErrorLog exception." + ExceptionUtil.getErrorMessage((Throwable)exception)), 1L);
            LOGGER.error((Object)("writeErrorLog exception." + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
    }

    public static SimpleDateFormat getDateFormat() {
        if (null == sFormat) {
            sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return sFormat;
    }

    public static boolean isNullStr(String str) {
        if (null != str && !str.equals("")) {
            return false;
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "IsNullStr:str is %s.", str));
        return true;
    }

    public static RestoreInfo getRestoreInfo(Alarm legoAlarm, String productName, String trapoid) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetRestoreInfo:productName is %s.", productName));
        return FaultUtil.getRestoreInfoLego(legoAlarm, productName, trapoid);
    }

    public static RestoreInfo getRestoreInfoLego(Alarm legoAlarm, String productName, String trapoid) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetRestoreInfoLego:productName is %s.", productName));
        RestoreInfo restoreInfo = new RestoreInfo();
        restoreInfo.setTtime(legoAlarm.getModTime());
        if (null != legoAlarm.getClearUser() && !"".equals(legoAlarm.getClearUser())) {
            restoreInfo.setClearUser(legoAlarm.getClearUser());
        } else {
            restoreInfo.setClearUser("system");
        }
        long clearTime = legoAlarm.getClearTime();
        if (0L == clearTime) {
            clearTime = legoAlarm.getModTime();
        }
        restoreInfo.setClearTime(clearTime);
        restoreInfo.setSequence(legoAlarm.getSequence());
        restoreInfo.setRestoredEntity(legoAlarm.getEntity());
        if ("0xE012C0011".equals(legoAlarm.getAlarmId()) || "0xE012C0013".equals(legoAlarm.getAlarmId())) {
            FaultDefine faultDefine = FaultUtil.getFaultDefine(legoAlarm, productName, trapoid);
            legoAlarm.setFaultDefine(faultDefine);
            String relateId = faultDefine.getRelateId();
            if (!FaultUtil.isNullStr(relateId)) {
                legoAlarm.setAlarmId(relateId);
            }
            return restoreInfo;
        }
        FaultUtil.setRestoredEntity(legoAlarm, productName, trapoid, restoreInfo);
        return restoreInfo;
    }

    private static void setRestoredEntity(Alarm legoAlarm, String productName, String trapoid, RestoreInfo restoreInfo) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "SetRestoredEntity:productName is %s.", productName));
        if (legoAlarm.getMoId() != 0L) {
            FaultDefine faultDefine = FaultUtil.getFaultDefine(legoAlarm, productName, trapoid);
            legoAlarm.setFaultDefine(faultDefine);
            String relateId = faultDefine.getRelateId();
            if (!FaultUtil.isNullStr(relateId)) {
                legoAlarm.setAlarmId(relateId);
            }
            restoreInfo.setRestoredEntity(FaultUtil.getEntity(legoAlarm.getMoId(), legoAlarm.getAlarmId(), faultDefine.getKeyIndexs(), legoAlarm.getParamList()));
        }
    }

    private static FaultDefine getFaultDefine(Alarm legoAlarm, String productName, String trapoid) {
        FaultDefine faultDefine = FaultDefineUtil.getLegoDefine(legoAlarm, productName, trapoid);
        if (null == faultDefine) {
            LOGGER.debug((Object)"getFaultDefine,FaultDefine is null");
            throw new LegoCheckedException("get FaultDefine failed, productName: " + productName + ", trapoid: " + trapoid + ", alarmId: " + legoAlarm.getAlarmId());
        }
        return faultDefine;
    }

    public static Alarm legoAlarmToAlarm(LegoAlarm legoAlarm) {
        if (legoAlarm == null) {
            LOGGER.debug((Object)"legoAlarmToAlarm,LegoAlarm is null");
            return null;
        }
        Alarm alarm = new Alarm();
        alarm.setAdvice(legoAlarm.getAdvice());
        alarm.setAlarmId(legoAlarm.getAlarmId());
        alarm.setClearStatus(legoAlarm.getClearStatus().getValue());
        alarm.setClearTime(legoAlarm.getClearTime());
        alarm.setClearUser(legoAlarm.getClearUser());
        alarm.setConfirmStatus(legoAlarm.getConfirmStatus().getValue());
        alarm.setConfirmTime(legoAlarm.getConfirmTime());
        alarm.setConfirmUser(legoAlarm.getConfirmUser());
        alarm.setCount(legoAlarm.getAlarmCount());
        alarm.setCreateTime(legoAlarm.getFirstTime());
        alarm.setDesc(legoAlarm.getAlarmDesc());
        alarm.setEffect(legoAlarm.getSysEffect());
        alarm.setEntity(legoAlarm.getEntity());
        alarm.setExtProps((Properties)legoAlarm.getExtProps());
        alarm.setLocation(legoAlarm.getLocation());
        alarm.setLowerNmsMoId(legoAlarm.getUpperMoId());
        alarm.setModTime(legoAlarm.getAlarmTime());
        alarm.setMoId(legoAlarm.getMoId());
        alarm.setMoIP(legoAlarm.getMoIP());
        alarm.setMoMainType(legoAlarm.getMoMainType());
        alarm.setMoName(legoAlarm.getMoName());
        alarm.setMoSubType(legoAlarm.getMoSubType());
        alarm.setMoUuid(legoAlarm.getMoUuid());
        alarm.setAlarmName(legoAlarm.getAlarmName());
        alarm.setParamList(legoAlarm.getAlarmParam());
        alarm.setParams(FaultSdkUtil.convertParam((String[])legoAlarm.getAlarmParam()));
        alarm.setProductName(legoAlarm.getProductName());
        alarm.setRelateId(legoAlarm.getRelateId());
        alarm.setSequence(legoAlarm.getAlarmSequence());
        alarm.setSeverity(legoAlarm.getAlarmLevel().getValue());
        alarm.setAlarmType(legoAlarm.getAlarmType());
        alarm.setPortUuid(legoAlarm.getPortUuid());
        alarm.setFaultDefine(legoAlarm.getFaultDefine());
        alarm.setGmt(legoAlarm.getGmt());
        alarm.setNmsIp(legoAlarm.getNmsIp());
        alarm.setIsFilterForThirdDevice(legoAlarm.getFilterForThirdDevice());
        alarm.setGroupDesc(legoAlarm.getGroupDesc());
        alarm.setGroupName(legoAlarm.getGroupName());
        alarm.setSourceId(legoAlarm.getSourceId());
        alarm.setSourceType(legoAlarm.getSourceType());
        alarm.setProjectId(legoAlarm.getProjectId());
        return alarm;
    }

    public static LegoAlarm alarmToLegoAlarm(Alarm alarm) {
        if (alarm == null) {
            LOGGER.error((Object)"alarmToLegoAlarm,Alarm is null");
            return null;
        }
        LegoAlarm legoAlarm = new LegoAlarm();
        FaultDefine faultDefine = FaultUtil.getLegoAlarmFaultDefine(alarm);
        legoAlarm.setFaultDefine(faultDefine);
        legoAlarm.setAlarmId(alarm.getAlarmId());
        legoAlarm.setClearStatus(FaultEnum.ClearState.getState((int)alarm.getClearStatus()));
        legoAlarm.setClearTime(alarm.getClearTime());
        legoAlarm.setClearUser(alarm.getClearUser());
        legoAlarm.setConfirmStatus(FaultEnum.ConfirmState.getState((int)alarm.getConfirmStatus()));
        legoAlarm.setConfirmTime(alarm.getConfirmTime());
        legoAlarm.setConfirmUser(alarm.getConfirmUser());
        legoAlarm.setAlarmCount(alarm.getCount());
        legoAlarm.setFirstTime(alarm.getCreateTime());
        legoAlarm.setEntity(alarm.getEntity());
        legoAlarm.setExtProps((Object)alarm.getExtProps());
        legoAlarm.setUpperMoId(alarm.getLowerNmsMoId());
        legoAlarm.setAlarmTime(alarm.getModTime());
        legoAlarm.setMoId(alarm.getMoId());
        legoAlarm.setMoIP(alarm.getMoIP());
        legoAlarm.setMoMainType(alarm.getMoMainType());
        legoAlarm.setMoName(alarm.getMoName());
        legoAlarm.setMoSubType(alarm.getMoSubType());
        legoAlarm.setMoUuid(alarm.getMoUuid());
        legoAlarm.setAlarmParam(FaultSdkUtil.convertParam((String)alarm.getParams()));
        legoAlarm.setAlarmSequence(alarm.getSequence());
        legoAlarm.setAlarmLevel(FaultEnum.AlarmSeverity.getSeverity((int)alarm.getSeverity()));
        legoAlarm.setPortUuid(alarm.getPortUuid());
        legoAlarm.setGmt(alarm.getGmt());
        legoAlarm.setNmsIp(alarm.getNmsIp());
        legoAlarm.setFilterForThirdDevice(alarm.getIsFilterForThirdDevice());
        legoAlarm.setGroupName(alarm.getGroupName());
        legoAlarm.setGroupDesc(alarm.getGroupDesc());
        legoAlarm.setSourceId(alarm.getSourceId());
        legoAlarm.setSourceType(alarm.getSourceType());
        return legoAlarm;
    }

    private static FaultDefine getLegoAlarmFaultDefine(Alarm alarm) {
        FaultDefine faultDefine = new FaultDefine();
        faultDefine.setAdvice(alarm.getAdvice());
        faultDefine.setFaultDesc(alarm.getDesc());
        faultDefine.setFaultLevel(alarm.getSeverity());
        faultDefine.setFaultId(alarm.getAlarmId());
        faultDefine.setFaultName(alarm.getAlarmName());
        faultDefine.setFaultType(alarm.getAlarmType());
        faultDefine.setId(alarm.getId());
        faultDefine.setLocation(alarm.getLocation());
        faultDefine.setProductName(alarm.getProductName());
        faultDefine.setSysEffect(alarm.getEffect());
        if (null != alarm.getFaultDefine()) {
            faultDefine.setKeyIndexs(alarm.getFaultDefine().getKeyIndexs());
            faultDefine.setRelateId(alarm.getFaultDefine().getRelateId());
            faultDefine.setMatchAlarm(alarm.getFaultDefine().getMatchAlarm());
        }
        return faultDefine;
    }

    public static LegoEvent eventToLegoEvent(Event event) {
        if (null == event) {
            LOGGER.debug((Object)"eventToLegoEvent,Event is null");
            return null;
        }
        LegoEvent legoEvent = new LegoEvent();
        FaultDefine faultDefine = new FaultDefine();
        faultDefine.setAdvice(event.getAdvice());
        faultDefine.setFaultDesc(event.getDesc());
        faultDefine.setFaultId(event.getAlarmId());
        faultDefine.setFaultName(event.getEventName());
        faultDefine.setFaultType(event.getEventType());
        faultDefine.setId(event.getId());
        faultDefine.setLocation(event.getLocation());
        faultDefine.setProductName(event.getProductName());
        faultDefine.setSysEffect(event.getEffect());
        legoEvent.setFaultDefine(faultDefine);
        legoEvent.setEventId(event.getEventId());
        legoEvent.setEventLevel(event.getEventType());
        legoEvent.setEventParam(FaultSdkUtil.convertParam((String)event.getParams()));
        legoEvent.setEventTime(event.getTime());
        legoEvent.setExtProps((Object)event.getExtProps());
        legoEvent.setId(NumberUtil.convertToInteger((Object)String.valueOf(event.getId())).intValue());
        legoEvent.setMoId(event.getMoId());
        legoEvent.setMoMainType(event.getMoMainType());
        legoEvent.setMoName(event.getMoName());
        legoEvent.setMoSubType(event.getMoSubType());
        legoEvent.setMoUuid(event.getMoUuid());
        legoEvent.setSequence(event.getSequence());
        legoEvent.setPortUuid(event.getPortUuid());
        legoEvent.setClearState(FaultEnum.ClearState.getState((int)event.getClearStatus()));
        legoEvent.setGmt(event.getGmt());
        return legoEvent;
    }

    public static Event legoEventToEvent(LegoEvent legoEvent) {
        if (null == legoEvent) {
            LOGGER.debug((Object)"legoEventToEvent,LegoEvent is null");
            return null;
        }
        Event event = new Event();
        event.setFaultDefine(legoEvent.getFaultDefine());
        event.setAdvice(legoEvent.getAdvice());
        event.setDesc(legoEvent.getEventDesc());
        event.setEffect(legoEvent.getSysEffect());
        event.setEventId(legoEvent.getEventId());
        event.setExtProps((Properties)legoEvent.getExtProps());
        event.setId(NumberUtil.convertToLong((Object)legoEvent.getId()).longValue());
        event.setLocation(legoEvent.getLocation());
        event.setMoId(legoEvent.getMoId());
        event.setMoIP(legoEvent.getMoIP());
        event.setMoMainType(legoEvent.getMoMainType());
        event.setMoName(legoEvent.getMoName());
        event.setMoSubType(legoEvent.getMoSubType());
        event.setMoUuid(legoEvent.getMoUuid());
        event.setEventName(legoEvent.getEventName());
        event.setParamList(legoEvent.getEventParam());
        event.setParams(FaultSdkUtil.convertParam((String[])legoEvent.getEventParam()));
        event.setProductName(legoEvent.getProductName());
        event.setSequence(legoEvent.getSequence());
        event.setTime(legoEvent.getEventTime());
        event.setEventType(legoEvent.getEventType());
        event.setPortUuid(legoEvent.getPortUuid());
        event.setClearStatus(legoEvent.getClearState().getValue());
        event.setGmt(legoEvent.getGmt());
        event.setGroupName(legoEvent.getGroupName());
        event.setGroupDesc(legoEvent.getGroupDesc());
        return event;
    }

    public static Alarm legoEvenToAlarm(LegoEvent legoEvent) {
        if (null == legoEvent) {
            LOGGER.debug((Object)"legoEvenToAlarm,LegoEvent is null");
            return null;
        }
        Alarm alarm = new Alarm();
        alarm.setAlarmId(legoEvent.getEventId());
        alarm.setCreateTime(legoEvent.getEventTime());
        alarm.setSeverity(legoEvent.getEventLevel());
        alarm.setSequence(legoEvent.getSequence());
        alarm.setModTime(legoEvent.getEventTime());
        alarm.setClearTime(legoEvent.getClearTime());
        alarm.setMoUuid(legoEvent.getMoUuid());
        alarm.setMoId(legoEvent.getMoId());
        alarm.setMoIP(legoEvent.getMoIP());
        alarm.setMoName(legoEvent.getMoName());
        alarm.setParamList(legoEvent.getEventParam());
        alarm.setTrapSrc(legoEvent.getTrapSrc());
        if (legoEvent.getTrapType() == 2) {
            alarm.setClearStatus(1);
            alarm.setClearUser("system");
        }
        alarm.setFaultDefine(legoEvent.getFaultDefine());
        alarm.setGmt(legoEvent.getGmt());
        alarm.setPortUuid(legoEvent.getPortUuid());
        alarm.setGroupName(legoEvent.getGroupName());
        alarm.setGroupDesc(legoEvent.getGroupDesc());
        alarm.setSourceId(legoEvent.getSourceId());
        alarm.setSourceType(legoEvent.getSourceType());
        return alarm;
    }

    public static AlarmDetail annotationToAlarmDetail(Annotation annotation) {
        LOGGER.debug((Object)"annotationToAlarmDetail");
        AlarmDetail alarmDetail = new AlarmDetail();
        alarmDetail.setId(annotation.getId());
        alarmDetail.setClearStatus(annotation.getClearStatus());
        alarmDetail.setClearTime(annotation.getClearTime());
        alarmDetail.setClearUser(annotation.getClearUser());
        alarmDetail.setConfirmStatus(annotation.getConfirmStatus());
        alarmDetail.setConfirmTime(annotation.getConfirmTime());
        alarmDetail.setConfirmUser(annotation.getConfirmUser());
        alarmDetail.setEntity(annotation.getEntity());
        alarmDetail.setSequence(annotation.getSequence());
        alarmDetail.setTtime(annotation.getModTime());
        return alarmDetail;
    }
}

