from utils.common.exception import HCCIException
import utils.common.log as logger
from plugins.eBackup.common.util import get_deploy_info_from_cmdb

logger.init("eBackup")


def get_params_from_env(project_id):
    ret_dict = {
        "eBackup_Datamover_nodes": {"value": "", "example": "192.168.10.1;192.168.10.2|192.168.20.1;192.168.20.2"}}

    def do_get_params_from_env():
        deploy_info = get_deploy_info_from_cmdb(project_id)
        if 0 == len(deploy_info["eBackup_Datamover_nodes"]):
            logger.error("Exception occurs when query ebackup deploy info: %s", str(deploy_info))
            return {}
        nodes_str_list = []
        for group, nodes in deploy_info["eBackup_Datamover_nodes"].items():
            logger.info(group + ":" + str(nodes))
            nodes_str_list.append(';'.join(nodes))
        ret_dict["eBackup_Datamover_nodes"]["value"] = '|'.join(nodes_str_list)
        return ret_dict

    try:
        return do_get_params_from_env()
    except HCCIException as e:
        logger.error("Exception occurs when query ebackup deploy info: %s", str(e))
        return {}
    except Exception as e:
        logger.error("Exception occurs when query ebackup deploy info: %s", str(e))
        return {}
