# -*- coding:utf-8 -*-
from utils.business.param_util import ParamUtil
from utils.business.project_condition_utils import get_project_condition_boolean
from utils.business.service_monitor.service_monitor import AuthProvider
from utils.business.service_monitor.service_monitor import Host
from utils.business.service_monitor.service_monitor import deploy_agent
from utils.common import log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("eBackup install ic agent")


class InstallICAgent(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.params = ParamUtil()
        self.__config_dict = \
            self.params.get_service_cloud_param(pod_id, "eBackup")

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """

    def main_handle(self, project_id):
        ip_list = []
        externalom_ip_lower = self.__config_dict['datamover_externalom_iplist'].lower()
        if get_project_condition_boolean(project_id, 'eBackup_ServerProxy_Driver') \
                or get_project_condition_boolean(project_id, 'eBackup_Proxy'):
            ip_list = externalom_ip_lower.split(',')

        agent_hosts = []
        for ip in ip_list:
            ansible_ssh_ip = ip
            ansible_ssh_port = 22
            agent_listen_address = ip
            agent_client_address = ip
            host = Host(ansible_ssh_ip, ansible_ssh_port, agent_listen_address, agent_client_address)
            agent_hosts.append(host)
        dmk_ip = self.params.get_param_value(self.pod_id, 'DMK', 'dmk_floatIp', 'dmk_floatIp')
        dmk_user_name = self.params.get_value_from_cloudparam(self.pod_id, "eBackup", "eBackup_dmk_user")
        dmk_pwd = self.params.get_value_from_cloudparam(self.pod_id, "eBackup", "eBackup_dmk_password")
        dmk_info = AuthProvider(dmk_ip, 8443, dmk_user_name, dmk_pwd)
        logger.info("begin to install IC Agent")
        result = deploy_agent(self.pod_id, dmk_info, agent_hosts, "root", "su")
        if not result:
            logger.error("Failed to install IC Agent")
            raise HCCIException(653009)
        logger.info("Success to install IC Agent")
        return Message(200)

    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            return self.main_handle(project_id)
        except HCCIException as e:
            return Message(500, e)
        except Exception as e:
            logger.error("Failed to install IC Agent" + str(e))
            return Message(500, e, e)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(self.project_id, self.pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """

# the code has been updated to python3.7
