# -*- coding:utf-8 -*-

import os

from utils.common.ssh_util import Ssh
from utils.business.dmk_util import DmkApi
from utils.common.fic_base import ToolClient
from utils.business.account_query import AccountQuery
import utils.common.software_package_util as FileUtil
from utils.business.param_util import ParamUtil
from plugins.eBackup.common.model import DmkUserInfo, SshInfo, DmkTaskInfo


class API(object):
    SCRIPT_PATH = os.path.realpath(__file__ + '/../../')
    DMK_CLIENT = ToolClient.DMK_CLIENT
    DMK = DmkApi()

    SSH_UTIL = Ssh()

    @classmethod
    def createdmkuser(cls, username, password, role, team_name):
        return cls.DMK.create_dmk_user(username, password, role, team_name)

    @classmethod
    def update_user_to_team(cls, user_id, role_id, team_lst):
        return cls.DMK.update_user_to_multi_team(user_id, role_id, team_lst)

    @classmethod
    def update_account_to_team(cls, dmkinfo: DmkUserInfo):
        return cls.DMK.update_account_to_multi_team(
            dmkinfo.user_name, dmkinfo.account_name, dmkinfo.team_lst, dmkinfo.passwd, dmkinfo.sudo_passwd)

    @classmethod
    def addaccounttodmk(
            cls, account, team_id, password, sudo_passwd):
        return cls.DMK.add_account_to_dmk(
            account, team_id, password, sudo_passwd)

    @classmethod
    def addaccounttodmk_with_key(
            cls, account, team_id, sudo_passwd, private_key_file_name):
        return cls.DMK.add_account_to_dmk_with_key(
            account, team_id, sudo_passwd, private_key_file_name)

    @classmethod
    def changedmkuserpasswd(
            cls, user_id, old_password, new_password):
        return cls.DMK.change_dmk_user_passwd(
            user_id, old_password, new_password)

    @classmethod
    def executedmkdeployment(cls, dmk_task_info: DmkTaskInfo, to_run, account_id):
        return cls.DMK.excute_dmk_deployment(
            dmk_task_info.app_name, to_run, dmk_task_info.app_version, dmk_task_info.deploy_action,
            dmk_task_info.host_info, dmk_task_info.config_info, account_id)

    @classmethod
    def find_file(
            cls, pkg_pre_name, pkg_post_name, pkg_version=None,
            scan_subdir=True):
        return FileUtil.find_software_package_by_name(
            pkg_pre_name, pkg_post_name, pkg_version,
            is_scan_subdir=scan_subdir)

    @classmethod
    def extract_file(cls, file_path, target_path):
        return FileUtil.extract_software_pkg(file_path, target_path)

    @classmethod
    def uploadpkgtodmk(cls, ssh_info: SshInfo, file_path, pod_id):
        return cls.DMK.upload_pkg_to_dmk(ssh_info.node_ips, ssh_info.ssh_user, ssh_info.ssh_passwd, file_path, pod_id)

    @classmethod
    def get_service_param_list(cls, db_handle, pod_id, service_name):
        return db_handle.get_service_cloud_param(pod_id, service_name)

    @classmethod
    def exec_ssh_command(cls, ssh_client, cmds):
        return cls.SSH_UTIL.ssh_exec_command_return(ssh_client, cmds)

    @classmethod
    def get_package_version(cls, package_name):
        name_list = package_name.split(' ')
        name_list = name_list[2].split('_')
        version = name_list[0].replace(" ", "")
        return version

    @classmethod
    def get_dmk_account_id(cls, user_name, account_name):
        return cls.DMK.get_dmk_account_id(user_name, account_name)

    @classmethod
    def getdmklastdeployconfig(cls, app_name, pod_id=None):
        return cls.DMK.get_dmk_last_deploy_config(app_name, pod_id)

    @classmethod
    def login_dmk(cls, dmk_ip, user_name, password, dmk_port='8443'):
        return cls.DMK.login_dmk(dmk_ip, user_name, password, dmk_port)

    @classmethod
    def get_dmk_info(cls, pod_id):
        return cls.DMK.get_dmk_info(pod_id)

    @classmethod
    def validate_account(cls, account_name, account_id, ips,
                         switch_mode='sudo'):
        return cls.DMK.validate_account(account_name, account_id, ips,
                                        switch_mode)

    @classmethod
    def delete_dmk_account(cls, account_id):
        return cls.DMK.delete_dmk_account(account_id)

    @classmethod
    def get_dmk_team_id(cls, team_name):
        return cls.DMK.get_dmk_team_id(team_name)

    @classmethod
    def get_account_info(cls, project_id, pod_id, sub_component_name):
        account_util = AccountQuery(project_id, pod_id)
        region_id = ParamUtil().get_param_value(pod_id, '', '', 'region0_id')
        account_list = [('hcp', 1), ('root', 1), ('admin', 6), ('op_svc_ebackup', 5), ('ebackup_karbor', 5)]
        accounts = account_util.get_account_info(region_id, account_list, None,
                                                 'eBackup', sub_component_name)
        ip_list = set(map(lambda x: x.get("ip", ''), accounts))
        account_info = {}
        for dmk_ip in ip_list:
            account_dict = {}
            [account_dict.setdefault(x.get("accountName"), x.get("newPasswd"))
             for x in accounts if x.get("ip") == dmk_ip]
            account_info[dmk_ip] = account_dict
        return account_info
# the code has been updated to python3.7
