# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.param_util import ParamUtil
from utils.business.project_condition_utils import get_project_condition_boolean
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

from plugins.eBackup.scripts.common.ebackup_util import CommonTools


class ConfigKmsCert(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        logger.init("eBackup Config Kms Cert")
        self.project_id = project_id
        self.pod_id = pod_id
        self.params = ParamUtil()
        self.ebackup = CommonTools(self.project_id, self.pod_id)
        self.__db_param_dict = \
            self.params.get_service_cloud_param(pod_id, "eBackup")

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message(200)

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            if get_project_condition_boolean(project_id, 'eBackup_ServerProxy_Driver') or \
                    get_project_condition_boolean(project_id, 'eBackup_Proxy'):
                install_sence = "eBackup"
                self.config_kms_cert(install_sence)
            return Message(200)
        except HCCIException as execute_err:
            return Message(500, execute_err)
        except Exception as execute_err:
            logger.error(f"Failed to connect ManageOne ,the reason is {execute_err}.")
            return Message(500, execute_err, execute_err)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message(200)

    def config_kms_cert(self, install_sence):
        logger.info("begin to config kms cert.")
        externalom_ip_lower = \
            self.__db_param_dict['datamover_externalom_iplist'].lower()
        ip_list = externalom_ip_lower.split(',')

        self.ebackup.reencrypt_cert_cipher(
            ip_list,
            self.__db_param_dict['hcp_ssh_password'],
            self.__db_param_dict['eBackup_os_root_password'])
        logger.info("config kms cert succ.")

# the code has been updated to python3.7
