# -*- coding:utf-8 -*-
import os

from utils.DBAdapter.DBConnector import BaseOps
from utils.business.param_util import ParamUtil
from utils.common import log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

from plugins.eBackup.common.model import SshInfo
from plugins.eBackup.common.api_adapter import API
from plugins.eBackup.scripts.common import ebackup_util as ebackup_handle


class UploadPackageToDmk(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        logger.init("eBackup")
        self.project_id = project_id
        self.pod_id = pod_id
        self.dmk_db = BaseOps()
        self.__db_param_dict = API.get_service_param_list(
            self.dmk_db, self.pod_id, 'eBackup')

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self._upload_package_to_dmk()
            return Message(200)
        except HCCIException as err:
            return Message(500, err)
        except Exception as err:
            logger.error(
                "Failed to upload package to DMK for eBackup plugin,"
                "the reason is %s" % err)
            return Message(500, err, err)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def get_all_parmas(self):
        params = ParamUtil()
        self.__db_param_dict['dmk_floatIp'] = params.get_param_value(
            self.pod_id, "DMK", 'dmk_floatIp', 'dmk_floatIp')
        dmk_param_key_list = [
            'dmk_ui_username',
            'dmk_os_business_username',
            'dmk_os_business_user_password'
        ]
        dmk_dict = API.get_dmk_info(self.pod_id)
        for key in dmk_param_key_list:
            self.__db_param_dict[key] = dmk_dict[key]

    def _upload_package_to_dmk(self):
        self.get_all_parmas()
        # 上传软件包eBackup DMK
        logger.info("eBackup: %s" % "upload eBckup-DMK package start.")
        path, name = API.find_file("OceanStor", "eBackup_DMK.zip")
        if name == "":
            raise HCCIException(653004, "OceanStor......eBackup_DMK.zip")
        file_path = os.path.join(path, name)
        ebackup_handle.check_compress_file([file_path])
        API.login_dmk(
            self.__db_param_dict['dmk_floatIp'],
            self.__db_param_dict['eBackup_dmk_user'],
            self.__db_param_dict['eBackup_dmk_password'])
        ssh_info = SshInfo(
            self.__db_param_dict['dmk_floatIp'],
            self.__db_param_dict['dmk_os_business_username'],
            self.__db_param_dict['dmk_os_business_user_password'])
        is_ok = API.uploadpkgtodmk(ssh_info, file_path, self.pod_id)
        if is_ok:
            logger.info("eBackup: %s" % "upload eBackup-DMK package success.")
        else:
            logger.error("eBackup: %s" % "upload eBackup-DMK package failed")
            raise HCCIException(653005, name)

# the code has been updated to python3.7
