# -*- coding:utf-8 -*-
import utils.common.log as logger

from plugins.eReplication.common.dr_api import API as DR_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result

logger.init("ConfigLogAndAlarm")


class ConfigLogAndAlarm(BaseSubJob):
    """
    完成云服务配置：
    4. 完成OC、CTS、SYSLOG对接
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        # 先获取client
        client = DR_API.get_dr_request_api(self.project_id, self.pod_id)
        # config oc
        DR_API.config_oc(self.project_id, self.pod_id, client)
        # config syslog
        DR_API.config_syslog(self.project_id, self.pod_id, client)
        # config cts
        DR_API.config_cts(self.project_id, self.pod_id, client)
