# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.client.iam_client import API as IAM_API
from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.dr_api import API as DR_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result

logger.init("CreateIAMAccount")


class CreateIAMAccount(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        # 创建IAM内置帐号
        iam_api = IAM_API(self.project_id, self.pod_id)
        iam_api.create_iam_account(Component.CSDR_L)
        # 创建op_svc帐号
        iam_api.create_op_svc_iam_account()
        # 创建IAM角色
        iam_api.create_iam_role(Component.CSDR_L)
        # 重写server配置文件
        DR_API.set_iam_service_name_info(project_id, pod_id)
