# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.client.mo_client import API as MO_API
from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Params

logger.init("RegisterMetrics")


class RegisterMetrics(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        params = Params(self.project_id, self.pod_id)
        region_id = params.project_region_id
        console_home = params.console_home_address
        MO_API.register_quota(
            self.project_id, self.pod_id, region_id, console_home,
            Component.CSHA_L)
        MO_API.register_meter(
            self.project_id, self.pod_id, region_id, console_home,
            Component.CSHA_L)
