# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.cipher_api import API as CIPHER_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.scripts.deploy.server.start_dr_service import \
    StartDRService

logger.init("DockingKMS")


class DockingKMS(BaseSubJob):
    """加密算法切换/对接KMS
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        result = CIPHER_API(self.project_id, self.pod_id, self.region_id). \
            cipher_change()
        logger.debug(f"Cipher change task return {result}.")
        if not result:
            return False
        CIPHER_API(self.project_id, self.pod_id, self.region_id). \
            clear_environment()
        return StartDRService(
            self.project_id, self.pod_id, self.regionid_list).execute(
            self.project_id, self.pod_id, self.regionid_list)
