# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.params import Params
from plugins.eReplication.common.os_api import API as OS_API

logger.init("ConfigDNSAndNTP")


class ConfigDNSAndNTP(BaseSubJob):
    """
    配置NTP与DNS
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        # 初始化参数
        nodes = Nodes(self.project_id, self.pod_id)
        params = Params(self.project_id, self.pod_id)
        time_zone = params.time_zone
        dns_ips = params.dns_ips
        # 配置DNS与NTP
        os_api = OS_API(
            nodes.arb_ip, nodes.arb_ssh_user, nodes.arb_ssh_pwd,
            nodes.arb_sudo_user, nodes.arb_sudo_pwd)
        os_api.config_dns_and_ntp(dns_ips, dns_ips, time_zone)
