# -*- coding:utf-8 -*-
import utils.common.log as logger

from plugins.eReplication.common.arb_api import API as ARB_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.scripts.deploy.quorum.upload_package import \
    UploadPackage

logger.init("InstallArbitration")


class InstallArbitration(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        arb_ins = ARB_API(project_id, pod_id)
        arb_ins.check_installed()
        return arb_ins.install_arb()

    def retry(self, project_id, pod_id, *args, **kwargs):
        upload = UploadPackage(project_id, pod_id)
        result = upload.execute(project_id, pod_id)
        if result.status_code != 200:
            return result
        return self.execute(project_id, pod_id)
