# -*- coding: utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.dr_api import API as DR_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.conditions import Condition
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Params

logger.info("RegisterCMDB")


class RegisterCMDB(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(RegisterCMDB, self).__init__(project_id, pod_id, regionid_list)
        self.condition = Condition(self.project_id)
        if self.condition.is_sm_compatible:
            self.to_mode = "SMCompatible"
        elif self.condition.is_sm_only:
            self.to_mode = "SMOnly"
        else:
            self.to_mode = "generalCipher"

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行设置云服务部署信息
        :param project_id:
        :param pod_id:
        :return:
        """
        params = Params(self.project_id, self.pod_id)
        extend_infos = DR_API.get_cloud_dr_service_installed_list(
            self.project_id, self.pod_id, params.project_region_id)
        block_supported, nas_supported = \
            DR_API.get_csdr_installed_info(
                self.project_id, self.pod_id, params.project_region_id)
        extend_infos.append(
            {"key": "CSDR_supported_block", "value": block_supported})
        extend_infos.append(
            {"key": "CSDR_supported_nas", "value": nas_supported})
        global_service_scale = params.get_global_scale_by_project_id if (
                self.condition.is_primary or self.condition.is_global_con_dr
        ) else ""
        extend_infos.append(
            {"key": "global_service_scale", "value": global_service_scale})
        extend_infos.append(
            {"key": "CipherType", "value": self.to_mode})
        cloud_service_info = {
            "indexName": Component.REPLICATION,
            "version": DR_API.get_bcm_version(self.project_id, self.pod_id),
            "extendInfos": extend_infos
        }
        DR_API.register_cmdb(
            self.project_id, self.pod_id, params.project_region_id,
            cloud_service_info)
