# -*- coding:utf-8 -*-
import threading

import utils.common.log as logger

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.conditions import Condition
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.thread import ExcThread
from plugins.eReplication.common.os_api import API as OS_API

logger.init("HardeningOS")


class HardeningOS(BaseSubJob):
    """
    完成Console软件的安装部署
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        # 初始化当前步骤的所有依赖参数
        nodes = Nodes(self.project_id, self.pod_id)
        reset_flag = True if Condition(self.project_id).is_primary else False
        enforce_funcs = list()
        thread_name = threading.current_thread().name
        for host in nodes.hosts:
            os_api = OS_API(
                host, nodes.ssh_user, nodes.ssh_pwd,
                nodes.sudo_user, nodes.sudo_pwd)
            enforce_func = (
                os_api.enforce_os, thread_name, (),
                {"user": nodes.ssh_user, "reset": reset_flag}
            )
            enforce_funcs.append(enforce_func)
        ExcThread.exec_func_in_thread(enforce_funcs)
