# -*- coding:utf-8 -*-
import utils.common.log as logger

from plugins.eReplication.common.client.mo_client import API as MO_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Params

logger.init("eReplication")


class RegisterCMDB(BaseSubJob):
    def __init__(self, project_id, pod_id):
        super(RegisterCMDB, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """Plug-in internal interface.

        Perform installation & configuration.
        :param project_id:
        :param pod_id:
        :return:Message object
        """
        # 刷新CMDB信息
        params = Params(project_id, pod_id)
        region_id = params.project_region_id
        global_service_scale = \
            Params(project_id, pod_id).get_global_scale_by_project_id
        extend_infos = [
            {
                "key": "global_service_scale",
                "value": global_service_scale
            }
        ]
        logger.info(f"Update extend info: {extend_infos}.")
        mo_api = MO_API(self.project_id, self.pod_id)
        mo_api.update_cloud_service_extend_info(region_id, extend_infos)
        cloud_service_info = mo_api.get_cloud_service_info(region_id)
        for extend_info in cloud_service_info[0]["extendInfos"]:
            if extend_info["key"] == "global_service_scale" and \
                    extend_info["value"] != global_service_scale:
                raise Exception("Failed to register the service scale.")
