# -*- coding:utf-8 -*-

import utils.common.log as logger
from utils.common.ssh_util import Ssh
from plugins.eReplication.common.lib.model import SSHClientInfo


class API(object):
    SSH_UTIL = Ssh()

    @classmethod
    def get_ssh_client(cls, ssh_client_info, port=22, timeout=20, pub_key=None, status=True):
        return cls.SSH_UTIL.ssh_create_client(
            ssh_client_info.host_ip, ssh_client_info.ssh_user, ssh_client_info.ssh_pwd, port, timeout, pub_key, status)

    @classmethod
    def get_sudo_ssh_client(cls, auth_provider, port=22, timeout=20, pub_key=None, status=True):
        ssh_client = API.get_ssh_client(
            SSHClientInfo(auth_provider.host, auth_provider.ssh_user, auth_provider.ssh_pwd), port, timeout, pub_key,
            status)
        API.send_command(
            ssh_client, f"su - {auth_provider.sudo_user}", "Password", timeout)
        API.send_command(ssh_client, auth_provider.sudo_pwd, "#", timeout)
        API.send_command(ssh_client, "TMOUT=0", "#", timeout)
        return ssh_client

    @classmethod
    def send_command(cls, ssh_client, cmd, expect="#", timeout=60):
        return cls.SSH_UTIL.ssh_send_command(ssh_client, cmd, expect, timeout)

    @classmethod
    def exec_command_return(
            cls, ssh_client, cmd, timeout=60, retry_times=0):
        return cls.SSH_UTIL.ssh_exec_command_return(
            ssh_client, cmd, timeout=timeout, retry_times=retry_times)

    @classmethod
    def exec_command_return_list(
            cls, ssh_client, cmd, timeout=60, retry_times=0):
        return cls.SSH_UTIL.ssh_exec_command_return_list(
            ssh_client, cmd, timeout=timeout, retry_times=retry_times)

    @classmethod
    def put_file(cls, host, user, passwd, source, destination='.', port=22):
        return cls.SSH_UTIL.put_file(
            host, user, passwd, source, destination=destination, port=port)

    @classmethod
    def get_file(cls, auth_ftp, source, destination='.', port=22):
        return cls.SSH_UTIL.get_file(
            auth_ftp.host, auth_ftp.ftp_user, auth_ftp.ftp_pwd, source, destination=destination, port=port)

    @classmethod
    def close_ssh(cls, ssh_client):
        try:
            if ssh_client:
                cls.SSH_UTIL.ssh_close(ssh_client)
        except Exception as err:
            logger.warn(f"Close ssh client failed: {err}.")
