# -*- coding:utf-8 -*-
from collections import namedtuple


class Auth(object):

    def __init__(self, host, ssh_user, ssh_pwd, sudo_user, sudo_pwd):
        self.host = host
        self.ssh_user = ssh_user
        self.ssh_pwd = ssh_pwd
        self.sudo_user = sudo_user
        self.sudo_pwd = sudo_pwd

    @property
    def auth_provider(self):
        auth = namedtuple(
            'auth', ['host', 'ssh_user', 'ssh_pwd', 'sudo_user', 'sudo_pwd'])
        return auth(self.host, self.ssh_user, self.ssh_pwd, self.sudo_user,
                    self.sudo_pwd)


class DMKInfo(object):

    def __init__(self, dmk_params):
        self._dmk_params = dmk_params

    @property
    def dmk_params(self):
        return namedtuple(
            "dmk_params", self._dmk_params.keys())(**self._dmk_params)


class ArbInfo(object):

    def __init__(self, arb_params):
        self._arb_params = arb_params

    @property
    def arb_params(self):
        return namedtuple(
            "arb_params", self._arb_params.keys())(**self._arb_params)


class AuthFtp(object):

    def __init__(self, host, ftp_user, ftp_pwd):
        self.host = host
        self.ftp_user = ftp_user
        self.ftp_pwd = ftp_pwd

    @property
    def auth_provider(self):
        auth = namedtuple(
            'auth', ['host', 'ftp_user', 'ftp_pwd'])
        return auth(self.host, self.ftp_user, self.ftp_pwd)
