# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.migrate_api import API as MIGRATE_API

logger.init("eReplication")


class UpdateConsole(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：升级console补丁

        :param project_id:
        :param pod_id:
        :return:
        """

        migrate_api = MIGRATE_API(self.project_id, self.pod_id, self.region_id)
        migrate_api.update_console()

