import utils.common.log as logger
from utils.business.service_monitor.service_monitor import ServiceMonitorCfg
from utils.business.service_monitor.service_monitor import ServiceNodeCfg
from utils.business.service_monitor.service_monitor import set_service_m_cfg
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")


class ServiceMonitor(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ServiceMonitor, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.karbor_util = KarborUtil(project_id, pod_id)
        self.param_tool = ParamTool(project_id, pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            return self._config_service_monitor(pod_id)
        except HCCIException as err:
            logger.error(f"Execute error:{str(err)}")
            return Message(500, err)
        except Exception as err:
            logger.error(f"Execute error:{err}")
            return Message(500, HCCIException("640016", str(err)))

    def _config_service_monitor(self, pod_id):
        logger.info('Start configuring Service Monitoring')
        karbor_iplist = self.karbor_util.get_karbor_ip_list()
        logger.info('karbor ip list:{}'.format(karbor_iplist))
        hosts = []
        templates = ["os_template", "cbs_server_template_id"]
        for karbor in karbor_iplist:
            for template_id in templates:
                karbor_node = ServiceNodeCfg(karbor, template_id, "CSBS-VBS_log_V200R001C30")
                hosts.append(karbor_node)

        service_m_cfg = ServiceMonitorCfg("CSBS-VBS-SERVER",
                                          "Cloud Backup Service Server",
                                          self.param_tool.get_region_id(),
                                          "CSBS-VBS-SERVER",
                                          "SAAS",
                                          hosts)
        if not set_service_m_cfg(pod_id, service_m_cfg):
            return Message(500, HCCIException("640015"))
        logger.info('Succeed configuring Service Monitoring')
        return Message(200)
