from plugins.CSBS.scripts.deploy.karborproxy.libs.error import BaseMsg


class ParamWrong(BaseMsg):
    """The parameter value is incorrect."""
    error_log = "input param's type is wrong,info:key is %s,value is %s"
    error_code = 650001


class ParamIsNullWrong(ParamWrong):
    """The parameter value cannot be empty."""
    error_log = "Parameter error, info: key %s, value null"
    error_code = 640114


class GetDNSIPError(BaseMsg):
    """Failed to obtain the DNS IP address."""
    error_log = "Failed to obtain the DNS IP address."
    error_code = 640093


class ParamNumUnequalError(BaseMsg):
    """The number of parameters is not equal."""
    error_log = "The number of parameters for %s is incorrect."
    error_code = 640097


class ParamFormatError(BaseMsg):
    """Incorrect parameter format."""
    error_log = "The format of the %s parameter is incorrect."
    error_code = 640113
