import utils.common.log as logger
from utils.business.manageone_util2 import ManageOneUtil2
from utils.common.exception import HCCIException

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxy
from plugins.CSBS.scripts.deploy.karborproxy.config.project_set import project_preset
from plugins.CSBS.scripts.deploy.karborproxy.config.shell_cmd import ShellCmd
from plugins.CSBS.scripts.deploy.karborproxy.config.ssh_cmd import SShCmd

logger.init("KarborProxy connect to manageone")


class ConfigOC(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.manageone = ManageOneUtil2()
        self.ssh = SShCmd()
        self.agentproxy = AgentProxy(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info('Adding a Trustlist .')
        self.add_white_list()
        logger.info('Start to configure alarms.')
        self.config_alarm_report()
        self.config_syslog()

    def config_alarm_report(self):
        cmd = ShellCmd.config_alarm % self.agentproxy.alarm_user
        self.ssh.ssh_exe_config_alarm(self.agentproxy, cmd)

    def add_white_list(self):
        ip_list = [
            self.agentproxy.karbor_proxy_ip0, self.agentproxy.karbor_proxy_ip1]
        logger.info("Add XAAS whitelist start.")
        logic_region = self.agentproxy.region
        is_ok = self.manageone.addXaasWhiteList(
            pod_id=self.pod_id,
            sysName="KarborProxy",
            ipList=ip_list,
            region="",
            groupType="",
            logicRegion=logic_region,
            restProtocol="1",
            snmpProtocol="",
            floatIp=self.agentproxy.management_float_ip)
        if not is_ok:
            logger.info("Add XAAS whitelist failed.")
            raise HCCIException(640108, '')
        logger.info("Add XAAS whitelist succ.")

    def config_syslog(self):
        logger.info("begin to config syslog.")
        rsyslog_ip = self.manageone.getlvsIp(self.pod_id)
        rsyslog_port = self.manageone.getUDPPort(self.pod_id)
        address = f"{rsyslog_ip}:{rsyslog_port}"
        self.ssh.ssh_cmds_to_all_proxys(self.agentproxy, ShellCmd.config_syslog % address)
        logger.info("config syslog succ.")
