import utils.common.log as logger
from utils.business.vm_util import PublicServiceOM
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxyVMINFO
from plugins.CSBS.scripts.deploy.karborproxy.config.pkg_param import PkgParam
from plugins.CSBS.scripts.deploy.karborproxy.config.project_set import project_preset

logger.init("create KarborProxy vm")


class CreateAgentProxyVM(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.vm_obj = PublicServiceOM()
        self.agent_proxy = AgentProxyVMINFO(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self._create_vm(pod_id)

    def _create_vm(self, pod_id):
        os_template_name = PkgParam().get_os_file_name(
            self.agent_proxy.is_arm())
        self.vm_obj.create_servers_with_group(
            pod_id,
            AgentProxyVMINFO.server_name,
            AgentProxyVMINFO.vm_group_name,
            self.agent_proxy.vm_cpu,
            self.agent_proxy.vm_mem,
            AgentProxyVMINFO.disk,
            [self.agent_proxy.karbor_proxy_ip0],
            AgentProxyVMINFO.network_name,
            sys_disk=AgentProxyVMINFO.sys_disk,
            image_file_name=os_template_name,
            vm_image_name=AgentProxyVMINFO.vm_image_name,
            availability_zone=AgentProxyVMINFO.az_name,
            volume_type=AgentProxyVMINFO.volume_type_name,
        )
        self.vm_obj.create_servers_with_group(
            pod_id,
            AgentProxyVMINFO.server_name,
            AgentProxyVMINFO.vm_group_workflow_name,
            self.agent_proxy.vm_cpu,
            self.agent_proxy.vm_mem,
            AgentProxyVMINFO.disk,
            [self.agent_proxy.karbor_proxy_ip1],
            AgentProxyVMINFO.network_name,
            sys_disk=AgentProxyVMINFO.sys_disk,
            image_file_name=os_template_name,
            vm_image_name=AgentProxyVMINFO.vm_image_name,
            availability_zone=self.agent_proxy.az_name,
            volume_type=self.agent_proxy.volume_type_name,
        )
        self.vm_obj.create_port(
            pod_id,
            self.agent_proxy.management_floatIP_name,
            self.agent_proxy.management_float_ip,
            AgentProxyVMINFO.network_name
        )

    def rollback(self, project_id, pod_id, regionid_list=None):
        self.vm_obj.delete_servers_with_group(
            pod_id,
            AgentProxyVMINFO.server_name,
            AgentProxyVMINFO.vm_group_name,
            [self.agent_proxy.karbor_proxy_ip0],
            network_name=self.agent_proxy.network_name)
        self.vm_obj.delete_servers_with_group(
            pod_id,
            AgentProxyVMINFO.server_name,
            AgentProxyVMINFO.vm_group_workflow_name,
            [self.agent_proxy.karbor_proxy_ip1],
            network_name=AgentProxyVMINFO.network_name
        )
        self.vm_obj.delete_port_by_name(
            pod_id,
            self.agent_proxy.management_floatIP_name,
            self.agent_proxy.management_float_ip,
            AgentProxyVMINFO.network_name
        )
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        try:
            self.rollback(project_id, pod_id)
        except HCCIException as err:
            return Message(500, err)
        except Exception as err:
            logger.error("delete vm error:%s" % str(err))
            return Message(500, err, err)
        return self.execute(project_id, pod_id)
