import utils.common.log as logger

from plugins.CSBS.common.iam_util import IamUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxy
from plugins.CSBS.scripts.deploy.karborproxy.config.project_set import project_preset
from plugins.CSBS.scripts.deploy.karborproxy.config.shell_cmd import ShellCmd
from plugins.CSBS.scripts.deploy.karborproxy.config.ssh_cmd import SShCmd

logger.init("eBackup KarborProxy vm")


class InitIAMAccount(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.ssh = SShCmd()
        self.agent_proxy = AgentProxy(project_id, pod_id)
        self.iam_util = IamUtil(project_id, pod_id)
        self.agent_proxy.op_service_account = self.iam_util.get_iam_account_info()
        self.agent_proxy.op_svc_account = self.iam_util.get_iam_account_info(account_type="op_svc_csbs")

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self._config_iam_info_to_proxy()
        self._config_op_svc_account()

    def _config_op_svc_account(self):
        logger.info("Start to configure the opsvc account.")
        cmd = ShellCmd.config_op_user % self.agent_proxy.op_svc_account.account_name
        self.ssh.ssh_exe_config_opsvc_cmd(self.agent_proxy, cmd)

    def _config_iam_info_to_proxy(self):
        logger.info("Configure IAM information on the proxy nodes.")
        cmd = ShellCmd.config_iam % self.agent_proxy.op_service_account.account_name
        self.ssh.ssh_exe_config_iam_cmd(self.agent_proxy, cmd)
