import utils.common.log as logger
from utils.business.install_csp_agent import CSPAgent
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxy

logger.init("KarborProxy")


class InstallCspAgent(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(InstallCspAgent, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.proxy_param = AgentProxy(self.project_id, self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._install_csp_agent()
        except Exception as err:
            logger.error(f"Failed to execute InstallCSPAgent, err_msg:{str(err)}.")
            return Message(500, HCCIException(640086, str(err)))
        logger.info(f"Succeed to install csp agent for {self.proxy_param} service.")
        return Message(200)

    def _get_proxy_node_list(self):
        proxy_user_info = self.proxy_param.get_proxy_user_info()
        proxy_ip_list = self.proxy_param.get_proxy_ip_list()
        logger.info(f"Succeed to obtain proxy ips, "
                    f"proxy ip list is:{proxy_ip_list}.")
        node_list = []
        for _ip in proxy_ip_list:
            node_info = {
                "node_ip": _ip,
                "process_username": proxy_user_info.user_name,
                "user_password": proxy_user_info.user_pwd,
                "sudo_cmd": "su",
                "root_password": proxy_user_info.root_pwd
            }
            node_list.append(node_info)
        return node_list

    def _install_csp_agent(self):
        logger.info(f"Start to install csp agent "
                    f"for {self.proxy_param.proxy_name} service.")
        proxy_node_list = self._get_proxy_node_list()
        ret_dic = \
            CSPAgent(self.pod_id).install_csp_agent(
                service_name=self.proxy_param.service_name,
                node_list=proxy_node_list)

        if ret_dic["result_code"] != "0":
            raise Exception("Install csp agent failed, result "
                            "code:[{}].".format(ret_dic["result_code"]))
        logger.info(f"Succeed to install csp agent "
                    f"for {self.proxy_param} service.")
