from plugins.CSBS.common import node_installer
from plugins.CSBS.common.ssh_client import SshClient


class KarborHealth(node_installer.ThreadInstaller):
    def __init__(self, karbor_node_list):
        self.karbor_node_list = karbor_node_list[:2]
        super(KarborHealth, self).__init__(self.karbor_node_list)
        self.error_service = list()
        self.ssh_client = SshClient()

    def check_service(self, ssh_client):
        cmds = "source /opt/huawei/dj/inst/utils.sh;show_service --node $HOSTNAME | sed 's/ //g'"
        result = self.ssh_client.ssh_exec_command_return(ssh_client, cmds)
        if not self.ssh_client.is_ssh_cmd_executed(result):
            self.error_service.append("show service failed.")
            return False
        for item in result:
            status = item.split("|")
            if len(status) == 6 and status[3] == "fault":
                self.error_service.append(status[1])
                return False
        return True

    def check_karbor(self, ssh_client):
        cmds = "source /opt/huawei/dj/inst/utils.sh;show_service --s karbor-api --n $HOSTNAME | sed 's/ //g'"
        result = self.ssh_client.ssh_exec_command_return(ssh_client, cmds)
        if not self.ssh_client.is_ssh_cmd_executed(result):
            self.error_service.append("show_service --s karbor-api")
            return False
        # 有环境出现命令执行返回值加上字符后缀情况, 导致无法替换cmd, 重复替换
        result = '\n'.join(result).replace(cmds.split('|')[0], '')
        if not self.ssh_client.is_expect_recv(["karbor-api"], result):
            return True
        cmds = "source /opt/huawei/dj/inst/utils.sh;check_karbor_connect | sed 's/ //g'"
        result = self.ssh_client.ssh_exec_command_return(ssh_client, cmds)
        if not self.ssh_client.is_ssh_cmd_executed(result):
            self.error_service.append("check_karbor_connect")
            return False
        if len(result) < 10:
            self.error_service.append("check_karbor_connect")
            return False
        for result in result:
            status = result.split("|")
            if len(status) == 7 and status[3] == "Error":
                self.error_service.append(status[1] + status[2])
                return False
        return True

    def install_thread(self, node):
        karbor_client = self.ssh_client.get_ssh_client(node)
        if self.check_service(karbor_client) and self.check_karbor(karbor_client):
            self.install_result[node.node_ip] = True
        self.ssh_client.ssh_close(karbor_client)

    def check_thread(self, node):
        self.check_result[node.node_ip] = True

    def rollback_thread(self, node):
        self.rollback_result[node.node_ip] = True
