import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.scripts.upgrade.karbor.sub_job_upgrade_karbor import UpgradeKarbor

logger.init("CSBS-VBS")

COMMANDS = "source /karbor/CSBS/bin/utils.sh;install_ommha_resource /karbor/CSBS/services/gaussdb/ha;" \
           "mkdir -p /opt/huawei/dj/bin/arbitrationtool/conf/;" \
           "\cp -rf /usr/local/bin/ha/arbitrationtool/conf/arb.properties /opt/huawei/dj/bin/arbitrationtool/conf/;" \
           "mkdir -p /opt/huawei/dj/DJSecurity/server-cert/alarm;" \
           "/usr/bin/cp -f /opt/huawei/dj/DJSecurity/server-cert/karbor/karbor-cert.pem " \
           "/opt/huawei/dj/DJSecurity/server-cert/alarm/alarm-cert.pem;" \
           "/usr/bin/cp -f /opt/huawei/dj/DJSecurity/server-cert/karbor/karbor-key.pem " \
           "/opt/huawei/dj/DJSecurity/server-cert/alarm/alarm-key.pem;" \
           "mkdir -p /opt/huawei/dj/bin/gaussdb && " \
           "/usr/bin/cp -rf /opt/fusionplatform/data/gaussdb /opt/huawei/dj/bin/gaussdb/data;" \
           "chown openstack:openstack -R /opt/huawei/dj/bin/gaussdb/"

POST_COMMANDS = "bash /karbor/CSBS/services/alarm/config.sh;bash /karbor/CSBS/services/cms/post_start.sh"


class SubUpgradeKarbor(UpgradeKarbor):
    def __init__(self, project_id, pod_id, regionid_list):
        super().__init__(project_id, pod_id, regionid_list)
        self.karbor_clients = [self.ssh_client.get_ssh_client(node) for node in self.karbor_operation.karbor_node_list]

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._copy_omm_ha_conf()
            result = super().execute(project_id, pod_id, regionid_list)
            if result.status_code == 500:
                return result
            self._post_upgrade()
        except Exception as e:
            logger.error(f"Karbor upgrade failed! reason: {e}")
            return Message(500, HCCIException(645011, str(e)))
        finally:
            for client in self.karbor_clients:
                self.ssh_client.ssh_close(client)
        return result

    def _copy_omm_ha_conf(self):
        try:
            self._alter_karbor_user(self.karbor_clients[0])
        except Exception as e:
            logger.error('Alter Karbor user failed.')
            raise e

        for index, client in enumerate(self.karbor_clients):
            # 升级前，执行config脚本，完成证书配置
            node = self.karbor_operation.karbor_node_list[index]
            for cmd in COMMANDS.split(';'):
                logger.info(f"Start to execute {cmd} on {node.node_ip}.")
                self.ssh_client.ssh_exec_command_return(client, cmd)

    def _alter_karbor_user(self, client):
        result = self.ssh_client.ssh_exec_command_return(client, "get_info.py gaussdb_admin_pwd")
        if not result:
            logger.error("Get admin password failed!")
            raise HCCIException(645011)
        gaussdb_admin_pwd = result[-3]
        result = self.ssh_client.ssh_exec_command_return(client, "get_info.py gaussdb_float_ip")
        if not result:
            logger.error("Get float ip failed!")
            raise HCCIException(645011)
        gaussdb_float_ip = result[-3]
        cmd = f"echo \"from kmc import kmc; print(kmc.API().decrypt(0, '{gaussdb_admin_pwd}'))\" | csbs_python"
        result = self.ssh_client.ssh_exec_command_return(client, cmd)
        if not result:
            logger.error("Get password failed!")
            raise HCCIException(645011)
        db_pwd = result[-3]
        # 修改数据库karbor用户权限
        logger.info("Start to enter docker container.")
        cmd = "docker exec -u root gaussdb /bin/bash -c " \
              "\"/opt/gaussdb/app/bin/gsql karbor -U " \
              f"gaussdba -W {db_pwd} -h {gaussdb_float_ip} -c 'alter role karbor superuser createdb;'\""
        self.ssh_client.ssh_exec_command_return(client, cmd)
        logger.info("Alter user success.")

    def _post_upgrade(self):
        for index, client in enumerate(self.karbor_clients):
            node = self.karbor_operation.karbor_node_list[index]
            # 升级前，执行config脚本，完成alarm数据库初始化
            for cmd in POST_COMMANDS.split(';'):
                logger.info(f"Start to execute {cmd} on {node.node_ip}.")
                result = self.ssh_client.ssh_exec_command_return(client, cmd)
                if not self.ssh_client.is_ssh_cmd_executed(result):
                    logger.error(f"Command execute failed! {result}")
                    raise HCCIException(645061, str(result))
                logger.info('Command execute success.')
