import utils.common.log as logger

from plugins.CSBS.common import node_installer
from plugins.CSBS.common.ebackup_util import EBackupUtil
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.ssh_client import SshClient


class KarborAZBackup(node_installer.Installer):
    def __init__(self, project_id, pod_id):
        super(KarborAZBackup, self).__init__()
        self.project_id = project_id
        self.pod_id = pod_id
        self.param_tool = ParamTool(project_id, pod_id)
        self.karbor_util = KarborUtil(project_id, pod_id)

    def install(self):
        karbor_client = SshClient()
        ebackup_util = EBackupUtil(self.project_id, self.pod_id)
        karbor_node_list = self.karbor_util.get_karbor_node_list()
        az_str = ebackup_util.get_ebackup_az().replace(",", " ")
        logger.info('Get az_list param:{}, and Ssh to karbor node:{}'.format(az_str, karbor_node_list[0].node_ip))
        ssh_client = karbor_client.get_ssh_client(karbor_node_list[0])
        work_dir = self.karbor_util.get_installer_workdir()
        cd_cmd = f"cd {work_dir}/CSBS/install_scripts"
        karbor_client.ssh_exec_command_return(ssh_client, cd_cmd)
        cmds = f"bash set_azbackup.sh {az_str}"
        logger.info('Cmd:{}; {}'.format(cd_cmd, cmds))
        result = karbor_client.ssh_exec_command_return(ssh_client, cmds)
        karbor_client.ssh_close(ssh_client)
        logger.info(f"cmds {cmds} exec succ, result :{result}")
        return karbor_client.is_ssh_cmd_executed(result)

    def check(self):
        return True

    def rollback(self):
        return True
