import utils.common.log as logger
from utils.business.project_condition_utils import get_project_conditions
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karbor.cbs_installer import cbs_managedatabackup

logger.init("ManageDataBackup")
MSG_200 = 200
MSG_500 = 500


class ManageDataBackup(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ManageDataBackup, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id

    def execute(self, project_id, pod_id, regionid_list=None):
        project_conditions = get_project_conditions(project_id)
        is_msb = project_conditions.get('ManageSysBackup', 0)
        if not is_msb:
            logger.info('Finished, current scence no need connecting to Data Backups')
            return Message(MSG_200)

        logger.info('Start connecting to Data Backups')
        try:
            install_result = cbs_managedatabackup.ManageDataBackup(project_id, pod_id).install()
        except Exception as err:
            logger.error(f"ManageDataBackup execute error:{err}")
            return Message(MSG_500, HCCIException("640074"))
        if not install_result:
            return Message(MSG_500, HCCIException("640074"))
        logger.info('Succeed connecting to Data Backups')
        return Message(MSG_200)

    def rollback(self, project_id, pod_id, regionid_list=None):
        try:
            rollback_result = cbs_managedatabackup.ManageDataBackup(project_id, pod_id).rollback()
        except Exception as err:
            logger.error(f"Execute error:{err}")
            return Message(MSG_500, HCCIException("640074"))
        if not rollback_result:
            return Message(MSG_500, HCCIException("640074"))
        return Message(MSG_200)
