import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.message import RESULT_CODE

logger.init("CSBS-VBS")


class BaseSubJob(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super().__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id):
        """Plug-in internal interface.

        Perform resource pre-check before installation,
        this interface is called by the execute interface,
        The tool framework does not directly call this interface.
        """
        return Message(RESULT_CODE['SUCCESS'])

    def execute(self, project_id, pod_id, *args, **kwargs):
        """Plug-in internal interface.

        Perform installation & configuration.
        """
        return Message(RESULT_CODE['SUCCESS'])

    def rollback(self, project_id, pod_id):
        """Plug-in internal interface.

        Perform job job failed rollback.
        """
        return Message(RESULT_CODE['SUCCESS'])

    def retry(self, project_id, pod_id):
        """Plug-in internal interface.

        Perform job failed retry.
        """
        self.rollback(project_id, pod_id)
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """Plug-in internal interface.

        Check before task execution.
        """
        return Message(RESULT_CODE['SUCCESS'])
