# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.manageone_util2 import ManageOneUtil2
from utils.common.message import Message

from plugins.CSBS.common.constant import CSBS_SERVICE_NAME
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS.common.upgrade.params import ParamsTools
from plugins.CSBS.common.util import check_url_param
from plugins.CSBS.scripts.upgrade.karbor.base import BaseSubJob


logger.init("CSBS")


class ConfigOCAlarm(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(ConfigOCAlarm, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.param_tool = ParamsTools(self.project_id)
        self.karbor_operation = KarborOperation(self.project_id)
        self.ssh_client = SshClient()
        self.mo_util2 = ManageOneUtil2()
        self.thirdpart_account, self.thirdparty_pwd = \
            self.mo_util2.get_thirdparty_infor(self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self._add_xaas_white_list()
        except Exception as err:
            logger.error(f"Execute error:{err}")
            return Message(500, f"Failed to register the XAAS white list., err_msg:{err}")
        try:
            self._config_alarm_endpoint()
        except Exception as err:
            logger.error(f"Execute error:{err}")
            return Message(500, f"Failed to config oc alarm, err_msg:{err}")
        logger.info("Succeed to config oc alarm.")
        return Message(200)

    def _add_xaas_white_list(self):
        logger.info("Start to add xaas white list.")
        karbor_ip_list = self.param_tool.get_karbor_ip_list(self.region_id)
        region_name = self.param_tool.get_region_name_by_region_id(
            self.region_id)
        result = self.mo_util2.add_xaas_white_list(
            params_list=[self.project_id, CSBS_SERVICE_NAME, karbor_ip_list,
                         "", "", region_name],
            rest_protocol="1",
            snmp_protocol="",
            float_ip=self.param_tool.get_karbor_float_ip())
        if not result:
            raise Exception("Failed to add xaas white list.")
        logger.info("Succeed to add xaas white list.")

    def _config_alarm_endpoint(self):
        oc_alarm_endpoint = f"{self.param_tool.get_oc_url(self.region_id)}/oc/v2.3"
        # 校验endpoint
        check_url_param(oc_alarm_endpoint)

        logger.info(f"Start to set_alarm_endpoint, alarm endpoint: {oc_alarm_endpoint}.")
        cmd = f"set_alarm_endpoint --alarm_url {oc_alarm_endpoint}"
        karbor_client = self.ssh_client.get_ssh_client(
            self.param_tool.get_karbor_node_list()[0])
        result = self.ssh_client.ssh_exec_command_return(karbor_client, 'test -e /opt/huawei/dj/inst/utils.sh')
        if self.ssh_client.is_ssh_cmd_executed(result):
            self.ssh_client.ssh_exec_command(karbor_client, "source /opt/huawei/dj/inst/utils.sh")
        self.ssh_client.ssh_send_command_expect(
            karbor_client, cmd, "user name", 30)
        self.ssh_client.ssh_send_command_expect(
            karbor_client, self.thirdpart_account, "password", 30)
        result = self.ssh_client.ssh_send_command_expect(
            karbor_client, self.thirdparty_pwd, "Successfully", 30)
        logger.info(result)
        self.ssh_client.ssh_close(karbor_client)
        if self.ssh_client.failed_to_return(result, "Successfully",
                                            karbor_client):
            raise Exception("Failed to config alarm endpoint for karbor node.")
        logger.info("Succeed to config alarm endpoint for karbor node.")
