# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.manageone_util2 import ManageOneUtil2
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.constant import CSBS_SERVICE_NAME
from plugins.CSBS.common.error_code import ROLLBACK_ADAPTIONPACKAGE_ERROR
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.util import auto_retry, get_env_config

MO_EXCEPT_CODE = "404"


class UnRegisterAdaptationPackage(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UnRegisterAdaptationPackage, self).__init__(project_id, pod_id, regionid_list)
        self.mo_util2 = ManageOneUtil2()

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info(f"Start to unregister {CSBS_SERVICE_NAME} adaptation package.")
        try:
            self.unregister_adaptation_package()
        except Exception as execute_error:
            logger.error(f"Execute error:{execute_error}.")
            return Message(500, HCCIException(ROLLBACK_ADAPTIONPACKAGE_ERROR))
        logger.info(f"Succeeded to unregister {CSBS_SERVICE_NAME} adaptation package.")
        return Message(200)

    @auto_retry(max_retry_times=5, delay_time=60)
    def unregister_adaptation_package(self):
        config_file = get_env_config()
        old_version = config_file.get_value_by_key_and_sub_key('AdaptationPackage', 'old_version')
        logger.info(f"Query {CSBS_SERVICE_NAME} adaptation pkg success: {old_version}.")
        if not old_version:
            logger.error('Old version is None.')
            raise HCCIException(ROLLBACK_ADAPTIONPACKAGE_ERROR, 'Old version is None.')

        result = self.mo_util2.rollback_adaptation_package(self.project_id, self.region_id,
                                                           CSBS_SERVICE_NAME, old_version)
        if result.get("status") == "failed" and MO_EXCEPT_CODE not in str(result["msg"]):
            message = result.get("msg")
            logger.error(f"Unregister {CSBS_SERVICE_NAME} adaptation package failed : {message}.")
            raise HCCIException(ROLLBACK_ADAPTIONPACKAGE_ERROR, message)
        logger.info(f"Ended to unregister {CSBS_SERVICE_NAME} adaptation package to OC successfully.")
