/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.manager.oceanprotect;

import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailResource;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSLA;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSlaManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.api.IAntiBlackmailSlaApiManager;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class OceanProtectSlaManager
implements IAntiBlackmailSlaManager {
    private static final int TRIGGERED_ONCE_A_YEAR = 4;
    private static final int BLACKMAIL_DETECTION_SNAPSHOT_BACKUP_STRATEGY = 1;
    private IAntiBlackmailSlaApiManager slaApiManager;

    public void setSlaApiManager(IAntiBlackmailSlaApiManager slaApiManager) {
        this.slaApiManager = slaApiManager;
    }

    public Optional<String> createSla(String devSn, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("type", 1);
        params.put("application", "CloudBackupFileSystem");
        ArrayList policyList = new ArrayList();
        HashMap<String, Object> policy = new HashMap<String, Object>();
        policy.put("name", "\u751f\u4ea7\u5feb\u7167");
        policy.put("type", "backup");
        policy.put("action", "snapshot");
        HashMap<String, Integer> retentionMap = new HashMap<String, Integer>();
        retentionMap.put("retention_type", 1);
        policy.put("retention", retentionMap);
        HashMap<String, Object> scheduleMap = new HashMap<String, Object>();
        scheduleMap.put("trigger", 4);
        scheduleMap.put("window_start", "00:00:00");
        scheduleMap.put("window_end", "00:00:01");
        scheduleMap.put("days_of_year", this.getPreDayStr());
        scheduleMap.put("trigger_action", "year");
        policy.put("schedule", scheduleMap);
        HashMap<String, Boolean> extendParamMap = new HashMap<String, Boolean>();
        extendParamMap.put("auto_retry", false);
        extendParamMap.put("is_security_snap", false);
        policy.put("ext_parameters", extendParamMap);
        policyList.add(policy);
        params.put("policy_list", policyList);
        return this.slaApiManager.createSla(devSn, params);
    }

    public String deleteSla(String devSn, String id) {
        return this.slaApiManager.deleteSla(devSn, id);
    }

    public Optional<AntiBlackmailSLA> querySlaByName(String devSn, String name) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("name", name);
        queryParams.put("applications", "CloudBackupFileSystem");
        return this.slaApiManager.querySlaByName(devSn, queryParams);
    }

    public OperationResult associateResourcesWithSla(String devSn, List<AntiBlackmailResource> resources, String slaId) {
        ArrayList resourceIdList = new ArrayList();
        ArrayList<String> fsIdList = new ArrayList<String>();
        for (AntiBlackmailResource resource : resources) {
            HashMap<String, String> resourceIdMap = new HashMap<String, String>();
            resourceIdMap.put("resource_id", resource.getUuid());
            resourceIdList.add(resourceIdMap);
            fsIdList.add(resource.getResourceId());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("resources", resourceIdList);
        params.put("sla_id", slaId);
        HashMap<String, Object> extendParamMap = new HashMap<String, Object>();
        extendParamMap.put("share_type", "NFS");
        extendParamMap.put("file_system_ids", fsIdList);
        params.put("ext_parameters", extendParamMap);
        return this.slaApiManager.associateResourcesWithSla(devSn, params);
    }

    public OperationResult removeSlaProtection(String devSn, List<String> resourceIdList) {
        return this.slaApiManager.removeSlaProtection(devSn, resourceIdList);
    }

    public OperationResult disableSlaProtection(String devSn, List<String> resourceIdList) {
        return this.slaApiManager.disableSlaProtection(devSn, resourceIdList);
    }

    private String getPreDayStr() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, -1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(calendar.getTime());
    }

    public String getPlatformType() {
        return AntiBlackMailEnumDefine.PlatformType.OCEAN_PROTECT.getValue();
    }
}

