/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.api;

import com.huawei.ism.cbb.proxy.protocol.rest.RestResponseData;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.api.BaseOceanProtectApiManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshot;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.api.IAntiBlackmailSnapshotApiManager;
import com.huawei.ism.drm.anti.blackmail.util.OceanProtectRestTransition;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OceanProtectSnapshotApiManager
extends BaseOceanProtectApiManager
implements IAntiBlackmailSnapshotApiManager {
    private static final Log LOGGER = LogFactory.getInstance(OceanProtectSnapshotApiManager.class);
    public static final String START_PAGE_KEY = "page_no";
    public static final String PAGE_SIZE_KEY = "page_size";
    private static final String SNAPSHOT_URI = "/v1/protected-objects";
    private static final String CREATE_SNAPSHOT_URI = "/v1/protected-objects/${pmFileSystemId}/action/backup";
    private static final String SNAPSHOT_QUERY_URI = "/v1/copies/detect-details";
    private static final String SNAPSHOT_DELETE_URI = "/v1/copies/${snapshotUuid}";
    private static final String SNAPSHOT_MISREPORT_DEAL_URI = "/v1/copies/${snapshotUuid}/detect-status";

    public Optional<String> createSnapshot(String devSn, Map<String, Object> params) {
        String resultJobId;
        RestResponseData postRes = null;
        String pmFileSystemId = "";
        try {
            RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
            pmFileSystemId = params.remove("pmFileSystemId").toString();
            String uri = CREATE_SNAPSHOT_URI.replace("${pmFileSystemId}", pmFileSystemId);
            postRes = connection.postResponseData(uri, params);
            if (VerifyUtil.isEmpty((Object)postRes) || postRes.getHttpStatusCode() != 200 || VerifyUtil.isEmpty((String)postRes.getBody())) {
                LOGGER.error((Object)"Protect(devSn: %s) creating snapshot(pmFileSystemId: %s) failed.", new Object[]{devSn, pmFileSystemId});
                throw new LegoCheckedException("Protect(devSn: " + devSn + ") creating snapshot(pmFileSystemId: " + pmFileSystemId + ") failed.");
            }
            JSONArray jsonArray = JSONArray.fromObject((Object)postRes.getBody());
            resultJobId = jsonArray.get(0).toString();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to trigger Protect Manager(devSn: %s) creating snapshot(pmFileSystemId: %s), error: %s.", new Object[]{devSn, pmFileSystemId, ExceptionUtil.getErrorMessage((Throwable)e)});
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Trigger Protect Manager(devSn: %s) creating snapshot(pmFileSystemId: %s) error, result is: %s, error: %s.", new Object[]{devSn, pmFileSystemId, JSONObject.fromObject(postRes).toString(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return Optional.empty();
        }
        return Optional.ofNullable(resultJobId);
    }

    public List<AntiBlackmailSnapshot> queryResourceSnapshots(String devSn, Map<String, String> queryParams) {
        List resultList;
        queryParams.put("orders", "-display_timestamp");
        if (queryParams.containsKey(START_PAGE_KEY) && queryParams.containsKey(PAGE_SIZE_KEY)) {
            RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
            String uri = this.concatenateQueryParam(SNAPSHOT_QUERY_URI, queryParams);
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("PMBatchResultKey", "items");
            resultList = connection.getBatch(uri, queryMap);
        } else {
            queryParams.put("PMBatchResultKey", "items");
            resultList = this.queryAllByPage(SNAPSHOT_QUERY_URI, devSn, queryParams);
        }
        return OceanProtectRestTransition.transitionAntiBlackmailSnapshot(resultList);
    }

    public OperationResult deleteSpecificSnapshot(String devSn, String snapshotUuid) {
        try {
            RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
            String uri = SNAPSHOT_DELETE_URI.replace("${snapshotUuid}", snapshotUuid);
            connection.deleteForObject(uri, null);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to delete snapshot.dev sn: %s, snapshotUuid: %s.", new Object[]{devSn, snapshotUuid});
            return new OperationResult("anti.blackmail.snapshot.delete.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to delete snapshot.dev sn: %s, snapshotUuid: %s.Error msg: %s", new Object[]{devSn, snapshotUuid, ExceptionUtil.getErrorMessage((Throwable)e)});
            return new OperationResult("anti.blackmail.snapshot.delete.operation", true, false, String.valueOf(0x300001L), new String[0]);
        }
        return new OperationResult("anti.blackmail.snapshot.delete.operation", true, true, new String[0]);
    }

    public OperationResult misreportDeal(String devSn, String snapshotUuid) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
            String uri = SNAPSHOT_MISREPORT_DEAL_URI.replace("${snapshotUuid}", snapshotUuid);
            paramMap.put("is_security_snap", "false");
            connection.putForObject(uri, paramMap);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to deal the misreport of the snapshot.dev sn: %s, snapshotUuid: %s.", new Object[]{devSn, snapshotUuid});
            return new OperationResult("anti.blackmail.snapshot.misreport.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to deal the misreport of the snapshot.dev sn: %s, snapshotUuid: %s.Error msg: %s", new Object[]{devSn, snapshotUuid, ExceptionUtil.getErrorMessage((Throwable)e)});
            return new OperationResult("anti.blackmail.snapshot.misreport.operation", true, false, String.valueOf(0x300001L), new String[0]);
        }
        return new OperationResult("anti.blackmail.snapshot.misreport.operation", true, true, new String[0]);
    }

    @Override
    protected String getPageSizeKey() {
        return PAGE_SIZE_KEY;
    }

    @Override
    protected String getStartPageKey() {
        return START_PAGE_KEY;
    }
}

