/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.api;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.api.BaseOceanProtectApiManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.api.IAntiBlackmailTaskApiManager;
import com.huawei.ism.drm.anti.blackmail.util.OceanProtectRestTransition;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OceanProtectTaskApiManager
extends BaseOceanProtectApiManager
implements IAntiBlackmailTaskApiManager {
    private static final Log LOGGER = LogFactory.getInstance(OceanProtectTaskApiManager.class);
    private static final String TASK_URI = "/v1/jobs";
    private static final String TASK_SUMMARY_URI = "/v1/jobs/summary";

    public List<AntiBlackmailPlatformTask> queryBatchTask(String devSn, Map<String, String> queryParams) {
        List resultList;
        if (queryParams.containsKey("pageSize") && queryParams.containsKey("startPage")) {
            RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
            String uri = this.concatenateQueryParam(TASK_URI, queryParams);
            resultList = connection.getBatch(uri, null);
        } else {
            resultList = this.queryAllByPage(TASK_URI, devSn, queryParams);
            LOGGER.info((Object)"The number of ProtectManager back task queried is %s, dev sn: %s", new Object[]{resultList.size(), devSn});
        }
        return OceanProtectRestTransition.transitionAntiBlackmailPlatformTask(resultList);
    }

    public Optional<AntiBlackmailPlatformTask> querySingleTask(String devSn, String taskId) {
        RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("jobId", taskId);
        String uri = this.concatenateQueryParam(TASK_URI, queryParams);
        Map resultMap = connection.get(uri, null);
        List<AntiBlackmailPlatformTask> taskList = OceanProtectRestTransition.transitionAntiBlackmailPlatformTask(Collections.singletonList(resultMap));
        if (VerifyUtil.isEmpty(taskList)) {
            LOGGER.info((Object)"No task information with id(%s) is found.Dev sn: %s", new Object[]{taskId, devSn});
            return Optional.empty();
        }
        return Optional.of(taskList.get(0));
    }

    public Map<String, String> queryTaskSummary(String devSn) {
        RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("PMBatchResultKey", "singleResultSet");
        return connection.get(TASK_SUMMARY_URI, queryParams);
    }

    @Override
    protected int getInitStartPage() {
        return 1;
    }
}

