/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.api;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.api.BaseOceanProtectApiManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailVstore;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.api.IAntiBlackmailVstoreApiManager;
import com.huawei.ism.drm.anti.blackmail.util.OceanProtectRestTransition;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OceanProtectVstoreApiManager
extends BaseOceanProtectApiManager
implements IAntiBlackmailVstoreApiManager {
    private static final Log LOGGER = LogFactory.getInstance(OceanProtectVstoreApiManager.class);
    private static final String VSTORE_DETECT_CONFIGS_URI = "/v1/anti/ransomware/vstore-detect-configs";

    public Optional<AntiBlackmailVstore> queryVstoreInfoByName(String devSn, String vstoreName) {
        List<AntiBlackmailVstore> vstoreList;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("vstoreName", vstoreName);
        try {
            List<Map<String, String>> resultList = this.queryAllByPage(VSTORE_DETECT_CONFIGS_URI, devSn, queryParams);
            vstoreList = OceanProtectRestTransition.transitionAntiBlackmailVstore(resultList);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Query vstore info error, vstoreName: %s, dev sn: %s, error msg", new Object[]{vstoreName, devSn, ExceptionUtil.getErrorMessage((Throwable)e)});
            return Optional.empty();
        }
        Optional<AntiBlackmailVstore> vstoreOptional = vstoreList.stream().filter(vstore -> vstoreName.equals(vstore.getVstoreName())).findAny();
        if (!vstoreOptional.isPresent()) {
            LOGGER.error((Object)"Vstore(name: %s) is not exists on ProtectManager(devSn: %s).", new Object[]{vstoreName, devSn});
        }
        return vstoreOptional;
    }

    public void configVstoreSmartDetection(String devSn, String vstoreId, boolean shouldOpenAutoDetect) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("configField", "COPY_DETECT");
        queryParams.put("isEnabled", shouldOpenAutoDetect);
        queryParams.put("isEnhancedDetect", false);
        ArrayList<String> vstoreIds = new ArrayList<String>();
        vstoreIds.add(vstoreId);
        queryParams.put("vstoreIds", vstoreIds);
        try {
            RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
            connection.putForObject(VSTORE_DETECT_CONFIGS_URI, queryParams);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Config vstore auto detect error, vstoreId: %s, dev sn: %s, error msg", new Object[]{vstoreId, devSn, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    @Override
    protected String getStartPageKey() {
        return "pageNum";
    }

    @Override
    protected int getInitStartPage() {
        return 1;
    }
}

